package com.tongda.tdpimssdk.resultVo.vo;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

/**
 * @Tittle: AssetVo
 * @description:
 * @Package: com.tongda.pimdemo.http.resultVo.vo
 * @Date 2023/5/25 19:10
 */
@Data
public class AssetVo {
    // 模型ID
    private String templateID;
    // 资产ID
    private String id;
    // 模型名称
    private String label;
    private String userID;
    private String userName;

    private List<AssetField> fields;

    /**
     * '[
     * {"key": "tdpim.asset.mainframe.cpu.count", "type":"SingleValue", "value":"6"},
     * {"key": "tdpim.asset.mainframe.cpu.temp", "type":"Range", "valueMin":"1", "valueMax":"5"},
     * {"key": "tdpim.asset.mainframe.area", "type":"MultiSelect", "selectedIDs":["CandidateValue-1110951999471353858","CandidateValue-1110951999471353859"]}
     */
    @Data
    @NoArgsConstructor
    @AllArgsConstructor
    public static class AssetField {
// 单值/单选
        private String key;
        private String mode;  //元数据模式
        private String value;


// 范围
//        private String key;
//        private String type;
        private String valueMin;
        private String valueMax;


// 多选
//        private String key;
//        private String type;
        private List<String> selectedIDs;
    }

}
