package com.tongda.tdpimssdk.resultVo;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 返回值枚举
 *
 * @author xcq
 * @date 2023/03/15
 */
@Getter
@AllArgsConstructor
public enum ResultVoEnum {
    SUCCESS(200, "success"),
    INTERNAL_SERVER_EXCEPTION(-1, "exception"),
    FAIL(1, "fail"),
    JSON_MAPPING_ERROR(2, "JsonProcessingException"),
    // 2000-2999 代表客户异常
    ACCOUNT_ERROR(2000, "检测到您尚未登录,请先登录！"),
    PARAM_ERROR(2001, "请求参数不合法！"),
    PARAM_PARSE_ERROR(2002, "请求参数解析失败"),
    // 3000-3999 代表服务异常
    XML_PARSE_ERROR(3000, "数据解析异常"),
    XQUERY_FILE_ANALYZE_ERROR(3001, "xquery文件解析出错"),
    JAXB_ANALYZE_ERROR(3002, "XML解析出错"),
    // 4000-4999 代表xquery请求异常
    XQUERY_IOEXCEPTION_ERROR(4000, "IoException"),
    XQUERY_EXECUTE_ERROR(4001, "请求出错,请检查！");
    private final Integer code;
    private final String desc;
}
