package com.tongda.tdpimssdk.resultVo;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * Rest返回值对象
 *
 * @author xcq
 * @date 2023/03/15
 */
@Builder
@Data
@AllArgsConstructor
@NoArgsConstructor
public class ResultVo<T> implements Serializable {

    private Integer code;
    private String desc;
    private T data;

    /**
     * 从枚举中构造返回值
     *
     * @param resultVoEnum 返回值枚举
     */
    public ResultVo(ResultVoEnum resultVoEnum) {
        this.code = resultVoEnum.getCode();
        this.desc = resultVoEnum.getDesc();
    }

    /**
     * 成功
     *
     * @param data 数据
     * @return {@link ResultVo}<{@link T}>
     */
    public static <T> ResultVo<T> success(T data) {
        ResultVo<T> resultVO = new ResultVo<>(ResultVoEnum.SUCCESS);
        resultVO.setData(data);
        return resultVO;
    }


    /**
     * 错误
     *
     * @param businessException 业务异常
     * @return {@link ResultVo}<{@link String}>
     */
    public static ResultVo<String> error(BusinessException businessException) {
        return ResultVo.<String>builder()
                .code(businessException.getCode())
                .desc(businessException.getDesc())
                .data(businessException.getMessage())
                .build();
    }

    /**
     * 错误
     *
     * @param exception 系统异常
     * @return {@link ResultVo}<{@link String}>
     */
    public static ResultVo<String> error(Exception exception) {
        ResultVo<String> resultVO = new ResultVo<>(ResultVoEnum.INTERNAL_SERVER_EXCEPTION);
        resultVO.setData(exception.getMessage());
        return resultVO;
    }
}
