package com.tongda.tdpimssdk.resultVo;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

/**
 * 自定义异常
 *
 * @author xcq
 * {@code @date} 2023/03/14
 */
@EqualsAndHashCode(callSuper = true)
@Data
@AllArgsConstructor
@NoArgsConstructor
public class BusinessException extends RuntimeException{

    private Integer code;
    private String desc;

    /**
     * 业务异常构造方法
     *
     * @param resultVoEnum 返回值枚举
     * @param exception    异常
     */
    public BusinessException(ResultVoEnum resultVoEnum, Throwable exception) {
        super(exception);
        this.code = resultVoEnum.getCode();
        this.desc = resultVoEnum.getDesc();
    }
}
