package com.tongda.tdpimssdk.remote;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.tongda.tdpimssdk.entities.AssetAbstract;
import com.tongda.tdpimssdk.entities.Entity;
import com.tongda.tdpimssdk.entities.common.CatalogRoot;
import com.tongda.tdpimssdk.http.PimHttpUtil;
import com.tongda.tdpimssdk.resultVo.vo.AssetVo;
import com.tongda.tdpimssdk.resultVo.vo.CatalogItem;
import com.tongda.tdpimssdk.resultVo.vo.GeneralPagerVo;
import com.tongda.tdpimssdk.resultVo.vo.TeamVo;

import java.io.File;
import java.util.List;

import static com.tongda.tdpimssdk.http.PimHttpUtil.resultUtil;

public class RemoteTdPimHelper {

    RemoteSaAuthHandler rsh;
    public RemoteTdPimHelper(RemoteSaAuthHandler rsh){
        this.rsh  = rsh;
    }

    /**
     * 查询资产模型清单
     * @return
     */
    public CatalogRoot fetchAssetTemplates(){
        String url="http://"+ this.rsh.serverIP +":"+ this.rsh.serverPort+"/pims/template?dbName="+ this.rsh.dbName;
        String response= PimHttpUtil.sendGet(this.rsh.saToken, url);
        String s=resultUtil(response);
        List<CatalogRoot> catList =  JSONObject.parseArray(s,CatalogRoot.class);
        if(catList.size() == 1){
            return catList.get(0);
        }
        return null;
    }

    /**
     * 查询文档模型清单
     * @return
     */
    public CatalogRoot fetchDocumentTemplates(){
        String url="http://"+  this.rsh.serverIP +":"+ this.rsh.serverPort+"/pims/template/document?dbName="+ this.rsh.dbName;
        String response=PimHttpUtil.sendGet(this.rsh.saToken, url);
        String s=resultUtil(response);
        List<CatalogRoot> catList =  JSONObject.parseArray(s,CatalogRoot.class);
        if(catList.size() == 1){
            return catList.get(0);
        }
        return null;
    }

    /**
     * 根据模型ID查询资产/文档清单
     * @param templateID
     * @param page
     * @param size
     * @return
     */
    public GeneralPagerVo<AssetAbstract> fetchAssetByTemplate(String templateID, int page, int size){
        String url="http://"+ this.rsh.serverIP +":"+this.rsh.serverPort+"/pims/asset?dbName="+this.rsh.dbName+"&templateID="+templateID+"&page="+page+"&size="+size;
        String response=PimHttpUtil.sendGet(this.rsh.saToken, url);
        String s=resultUtil(response);
        return JSONObject.parseObject(s,new TypeReference<GeneralPagerVo<AssetAbstract>>(){});
    }


    /**
     * 查询资产所属业务
     * @param id
     * @return
     */
    public List<Entity> fetchAssetAppViewPath(String id){
        String url="http://"+  this.rsh.serverIP +":"+ this.rsh.serverPort+"/pims/asset/business/path?dbName="+ this.rsh.dbName+"&id="+id;
        String response=PimHttpUtil.sendGet(this.rsh.saToken,url);
        String s=resultUtil(response);
        return JSONObject.parseArray(s,Entity.class);
    }

    /**
     * 查询业务清单
     * @return
     */
    public List<Entity> fetchAppConfigList(String label) {

        String url="http://"+  this.rsh.serverIP +":"+ this.rsh.serverPort+"/pims/business?dbName="+ this.rsh.dbName+"&label="+label;
        String response=PimHttpUtil.sendGet(this.rsh.saToken, url);
        String s=resultUtil(response);
        return JSONObject.parseArray(s,Entity.class);
    }

    //------------资产相关------------

    /**
     * 修改资产
     * @param vo
     * @return
     */
    public String updateAssetValues(AssetVo vo){
        String url="http://"+ this.rsh.serverIP +":"+ this.rsh.serverPort+"/pims/asset/field?dbName="+this.rsh.dbName;
        String response= PimHttpUtil.sendPut(this.rsh.saToken,url,(JSONObject)JSONObject.toJSON(vo));
        String s=  resultUtil(response);

        return s;
    }

    /**
     * 新建资产
     * @param vo
     * @return
     */
    public String createAsset(AssetVo vo){
        String url="http://"+ this.rsh.serverIP +":"+ this.rsh.serverPort+"/pims/asset?dbName="+this.rsh.dbName;
        String response= PimHttpUtil.sendPost(this.rsh.saToken,url,(JSONObject)JSONObject.toJSON(vo));
        String s= resultUtil(response);
        return s;

    }

    /**
     * 删除资产
     * @param id
     * @return
     */
    public String  deleteAsset(String id)  {
        String url="http://"+ this.rsh.serverIP +":"+this.rsh.serverPort+"/pims/asset?dbName="+this.rsh.dbName+"&id="+id;
        String response= PimHttpUtil.sendDelete(this.rsh.saToken,url);
        String s= resultUtil(response);
        return s;
    }

    /**
     * 查询资产
     * @param id
     * @return
     */
    public RemoteAsset fetchAsset(String id) {
        String url="http://"+ this.rsh.serverIP +":"+this.rsh.serverPort+"/pims/asset/details?dbName="+this.rsh.dbName+"&id="+id;
        String response= PimHttpUtil.sendGet(this.rsh.saToken,url);
        String s= resultUtil(response);
        RemoteAsset ra =  JSONObject.parseArray(s,RemoteAsset.class).get(0);
        ra.setRsh(rsh);
        return ra;
    }

    //------------文档相关------------

    /**
     * 创建文档
     * @param vo
     * @return
     */
    public String createDocument(AssetVo vo){
        String url="http://"+ this.rsh.serverIP +":"+this.rsh.serverPort+"/pims/asset/document?dbName="+this.rsh.dbName;
        String response= PimHttpUtil.sendPost(this.rsh.saToken,url,(JSONObject)JSONObject.toJSON(vo));
        String s=  resultUtil(response);
        return s;
    }

    /**
     * 查询文档
     * @param id
     * @return
     */
    public RemoteDocument fetchDocument(String id) {
        String url="http://"+ this.rsh.serverIP +":"+this.rsh.serverPort+"/pims/document/content?dbName="+this.rsh.dbName+"&id="+id;
        String response= PimHttpUtil.sendGet(this.rsh.saToken,url);
        String s= resultUtil(response);
        return JSONObject.parseArray(s,RemoteDocument.class).get(0);
    }

    /**
     * 修改文档
     * @param vo
     * @return
     */
    public String updateDocumentValues(AssetVo vo) {
        String url="http://"+ this.rsh.serverIP +":"+this.rsh.serverPort+"/pims/asset/document/field?dbName="+this.rsh.dbName;
        String response= PimHttpUtil.sendPut(this.rsh.saToken,url,(JSONObject)JSONObject.toJSON(vo));
        String s= resultUtil(response);
        return s;
    }

    /**
     * 删除文档
     * @param id
     * @return
     */
    public String deleteDocument(String id)  {
        String url="http://"+ this.rsh.serverIP +":"+this.rsh.serverPort+"/pims/asset/document?dbName="+this.rsh.dbName+"&id="+id;
        String response= PimHttpUtil.sendDelete(this.rsh.saToken,url);
        String s= resultUtil(response);
        return s;
    }

    /**
     * 上传文件
     * @param id
     * @param file
     * @return
     */
    public String uploadBinary(String id, File file)  {
        String url="http://"+ this.rsh.serverIP +":"+this.rsh.serverPort+"/pims/document/upload?dbName="+this.rsh.dbName+"&id="+id;
        String response= PimHttpUtil.uploadFile(this.rsh.saToken,url,file);
        String s= resultUtil(response);
        return s;
    }

    //------------业务相关------------

    /**
     * 新建业务
     * @param teamVo
     * @return
     */
    public String createAppConfig(TeamVo teamVo){
        String url="http://"+ this.rsh.serverIP +":"+this.rsh.serverPort+"/pims/business?dbName="+this.rsh.dbName;
        String response= PimHttpUtil.sendPost(this.rsh.saToken,url,(JSONObject)JSONObject.toJSON(teamVo));
        String s=  resultUtil(response);
        return s;
    }

    /**
     * 查询业务详情
     * @param id
     * @return
     */
    public RemoteAppConfiguration fetchAppConfig(String id) {
        String url="http://"+ this.rsh.serverIP +":"+this.rsh.serverPort+"/pims/business/details?dbName="+this.rsh.dbName+"&id="+id;
        String response= PimHttpUtil.sendGet(this.rsh.saToken,url);
        String s= resultUtil(response);
        return JSONObject.parseArray(s,RemoteAppConfiguration.class).get(0);
    }

    /**
     * 查询目录下资产列表
     * @param id
     * @return
     */
    public List<CatalogRoot> queryAssetByCatalog(String id, String catalogID) {
        String url="http://"+ this.rsh.serverIP +":"+this.rsh.serverPort+"/pims/business/details?dbName="+this.rsh.dbName+"&id="+id+"&catalogID="+catalogID;
        String response= PimHttpUtil.sendGet(this.rsh.saToken,url);
        String s= resultUtil(response);
        return JSONObject.parseArray(s,CatalogRoot.class);
    }

    /**
     *  删除业务
     * @param id
     * @return
     */
    public String deleteAppConfig(String id)  {
        String url="http://"+ this.rsh.serverIP +":"+this.rsh.serverPort+"/pims/business?dbName="+this.rsh.dbName;
        TeamVo teamVo=new TeamVo();
        teamVo.setTeamID(id);
        String response= PimHttpUtil.sendDeleteBody(this.rsh.saToken,url,(JSONObject)JSONObject.toJSON(teamVo));
        String s= resultUtil(response);
        return s;
    }

    /**
     *  将资源从业务团队中移除
     * @return
     */
    public String removeAssetFromApp(CatalogItem item)  {
        String url="http://"+ this.rsh.serverIP +":"+this.rsh.serverPort+"/pims/business/asset?dbName="+this.rsh.dbName;
        String response= PimHttpUtil.sendDeleteBody(this.rsh.saToken,url,(JSONObject)JSONObject.toJSON(item));
        String s= resultUtil(response);
        return s;
    }

    /**
     * 将资产加入业务
     * @param item
     * @return
     */
    public String addAssetRefToAppConfig(CatalogItem item) {
        String url="http://"+ this.rsh.serverIP +":"+this.rsh.serverPort+"/pims/business/asset?dbName="+this.rsh.dbName;
        String response= PimHttpUtil.sendPut(this.rsh.saToken,url,(JSONObject)JSONObject.toJSON(item));
        String s= resultUtil(response);
        return s;
    }



}
