package com.tongda.tdpimssdk.remote;

import com.alibaba.fastjson.JSONObject;
import com.tongda.tdpimssdk.entities.Product;
import com.tongda.tdpimssdk.http.PimHttpUtil;
import com.tongda.tdpimssdk.resultVo.vo.AssetVo;
import lombok.Data;

import java.util.List;

import static com.tongda.tdpimssdk.http.PimHttpUtil.resultUtil;
@Data
public class RemoteAsset extends Product {

    protected RemoteSaAuthHandler rsh;

    public String updateAssetValues(List<AssetVo.AssetField> fields){
        AssetVo assetVo=new AssetVo();
        assetVo.setId(this.id);
        assetVo.setFields(fields);


        String url="http://"+ this.rsh.serverIP +":"+ this.rsh.serverPort+"/pims/asset/field?dbName="+this.rsh.dbName;
        String response= PimHttpUtil.sendPut(this.rsh.saToken,url,(JSONObject)JSONObject.toJSON(assetVo));
        String s=  resultUtil(response);
        return s;
    }
}
