package com.tongda.tdpimssdk.http;

import com.alibaba.fastjson.JSONObject;
import org.apache.http.Consts;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.HttpEntity;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.*;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;

public class PimHttpUtil {

    public static String loginGetSaToken(String url , String user , String password){
        try {
        //创建httpClient实例
        CloseableHttpClient client = HttpClients.createDefault();
        //创建一个uri对象
        URIBuilder uriBuilder = null;
        uriBuilder = new URIBuilder(url);

        //塞入form参数
        uriBuilder.addParameter("name", user);
        uriBuilder.addParameter("pwd", password);
        //创建httpGet远程连接实例,这里传入目标的网络地址

        HttpGet httpGet = new HttpGet(uriBuilder.build());
        // 设置配置请求参数(没有可忽略)
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(3000)// 连接主机服务超时时间
                    .setConnectionRequestTimeout(10000)// 请求超时时间
                    .setSocketTimeout(60000)// 数据读取超时时间
                    .build();
        // 为httpGet实例设置配置
        httpGet.setConfig(requestConfig);
        //执行请求
        CloseableHttpResponse response = client.execute(httpGet);

        Header [] headers=response.getHeaders("Set-Cookie");
        String satoken="";
        for (Header header:headers){
            if (header.getName().equals("Set-Cookie")){
                for(HeaderElement headerElement:header.getElements()){
                    if (headerElement.getName().equals("satoken"))
                        satoken=headerElement.getValue();
                }
            }
        }
        //获取响应实体, 响应内容
        HttpEntity entity = response.getEntity();
        //通过EntityUtils中的toString方法将结果转换为字符串
        String str = EntityUtils.toString(entity);
        System.out.println(str);
        response.close();
        client.close();

        return satoken;

        } catch (URISyntaxException e) {
            throw new RuntimeException(e);
        } catch (ClientProtocolException e) {
            throw new RuntimeException(e);
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String sendGet(String token,String url){
        try {
            //创建httpClient实例
            CloseableHttpClient client = HttpClients.createDefault();
            //创建一个uri对象
            URIBuilder uriBuilder = null;
            uriBuilder = new URIBuilder(url);
            //创建httpGet远程连接实例,这里传入目标的网络地址
            HttpGet httpGet = new HttpGet(uriBuilder.build());
            httpGet.setHeader("Satoken", token);
            // 设置配置请求参数(没有可忽略)
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(60000)// 连接主机服务超时时间
                    .setConnectionRequestTimeout(60000)// 请求超时时间
                    .setSocketTimeout(60000)// 数据读取超时时间
                    .build();
            // 为httpGet实例设置配置
            httpGet.setConfig(requestConfig);
            //执行请求
            CloseableHttpResponse response = client.execute(httpGet);
            //获取Response状态码
            int statusCode = response.getStatusLine().getStatusCode();
            System.out.println(statusCode);
            //获取响应实体, 响应内容
            HttpEntity entity = response.getEntity();
            //通过EntityUtils中的toString方法将结果转换为字符串
            String str = EntityUtils.toString(entity);
            System.out.println(str);
            response.close();
            client.close();

            return str;

        } catch (URISyntaxException e) {
            throw new RuntimeException(e);
        } catch (ClientProtocolException e) {
            throw new RuntimeException(e);
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String sendPost(String token,String url , JSONObject jsonObject){
        try {
            //创建httpClient实例
            CloseableHttpClient client = HttpClients.createDefault();
            //创建一个uri对象
            URIBuilder uriBuilder = null;
            uriBuilder = new URIBuilder(url);
            //创建httpGet远程连接实例,这里传入目标的网络地址
            HttpPost httpPost = new HttpPost(uriBuilder.build());
            httpPost.setHeader("Satoken", token);
            // 设置配置请求参数(没有可忽略)
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(60000)// 连接主机服务超时时间
                    .setConnectionRequestTimeout(60000)// 请求超时时间
                    .setSocketTimeout(60000)// 数据读取超时时间
                    .build();
            // 为httpGet实例设置配置
            httpPost.setHeader("Content-Type", "application/json");
            httpPost.setConfig(requestConfig);
            StringEntity entity = new StringEntity(jsonObject.toString(), Consts.UTF_8);
            httpPost.setEntity(entity);
            //执行请求
            CloseableHttpResponse response = client.execute(httpPost);
            //获取Response状态码
            int statusCode = response.getStatusLine().getStatusCode();
            //获取响应实体, 响应内容
            HttpEntity responseEntity = response.getEntity();
            //通过EntityUtils中的toString方法将结果转换为字符串
            String str = EntityUtils.toString(responseEntity);
            response.close();
            client.close();

            return str;

        } catch (URISyntaxException e) {
            throw new RuntimeException(e);
        } catch (ClientProtocolException e) {
            throw new RuntimeException(e);
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String uploadFile(String token,String url , File file){
        try {
            //创建httpClient实例
            CloseableHttpClient client = HttpClients.createDefault();
            //创建一个uri对象
            URIBuilder uriBuilder = null;
            uriBuilder = new URIBuilder(url);
            HttpPost httpPost = new HttpPost(uriBuilder.build());
            // 设置请求头信息，鉴权(没有可忽略)
            httpPost.setHeader("Satoken", token);
            // 设置配置请求参数(没有可忽略)
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(60000)// 连接主机服务超时时间
                    .setConnectionRequestTimeout(60000)// 请求超时时间
                    .setSocketTimeout(60000)// 数据读取超时时间
                    .build();
            // 为实例设置配置
//            httpPost.setHeader("Content-Type", "multipart/form-data");
            httpPost.setConfig(requestConfig);

            httpPost.setEntity(
                    MultipartEntityBuilder.create()
                            .setCharset(StandardCharsets.UTF_8)
                            .setContentType(ContentType.MULTIPART_FORM_DATA)
                            .setMode(HttpMultipartMode.BROWSER_COMPATIBLE)
//                            .setCharset(Charset.forName("UTF-8"))
                            // 还有文件的话继续往下添加
                            .addBinaryBody("file", file)
                            .build()
            );

            //执行请求
            CloseableHttpResponse response = client.execute(httpPost);
            //获取Response状态码
            int statusCode = response.getStatusLine().getStatusCode();
            //获取响应实体, 响应内容
            HttpEntity responseEntity = response.getEntity();
            //通过EntityUtils中的toString方法将结果转换为字符串
            String str = EntityUtils.toString(responseEntity);
            response.close();
            client.close();

            return str;

        } catch (URISyntaxException e) {
            throw new RuntimeException(e);
        } catch (ClientProtocolException e) {
            throw new RuntimeException(e);
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String sendPut(String token,String url , JSONObject jsonObject){
        try {
            //创建httpClient实例
            CloseableHttpClient client = HttpClients.createDefault();
            //创建一个uri对象
            URIBuilder uriBuilder = null;
            uriBuilder = new URIBuilder(url);
            //创建远程连接实例,这里传入目标的网络地址
            HttpPut httpPut = new HttpPut(uriBuilder.build());
            httpPut.setHeader("Satoken", token);
            // 设置配置请求参数(没有可忽略)
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(60000)// 连接主机服务超时时间
                    .setConnectionRequestTimeout(60000)// 请求超时时间
                    .setSocketTimeout(60000)// 数据读取超时时间
                    .build();
            // 为实例设置配置
            httpPut.setHeader("Content-Type", "application/json");
            httpPut.setConfig(requestConfig);
            StringEntity entity = new StringEntity(jsonObject.toString(), Consts.UTF_8);
            httpPut.setEntity(entity);
            //执行请求
            CloseableHttpResponse response = client.execute(httpPut);
            //获取Response状态码
            int statusCode = response.getStatusLine().getStatusCode();
            //获取响应实体, 响应内容
            HttpEntity responseEntity = response.getEntity();
            //通过EntityUtils中的toString方法将结果转换为字符串
            String str = EntityUtils.toString(responseEntity);
            response.close();
            client.close();

            return str;
        } catch (URISyntaxException e) {
            throw new RuntimeException(e);
        } catch (ClientProtocolException e) {
            throw new RuntimeException(e);
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String sendDelete(String token,String url){
        try {
            //创建httpClient实例
            CloseableHttpClient client = HttpClients.createDefault();
            //创建一个uri对象
            URIBuilder uriBuilder = new URIBuilder(url);
            //创建远程连接实例,这里传入目标的网络地址
            HttpDelete httpDelete = new HttpDelete(uriBuilder.build());
            // 设置请求头信息，鉴权(没有可忽略)
            httpDelete.setHeader("Satoken", token);
            // 设置配置请求参数(没有可忽略)
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(60000)// 连接主机服务超时时间
                    .setConnectionRequestTimeout(60000)// 请求超时时间
                    .setSocketTimeout(60000)// 数据读取超时时间
                    .build();
            // 为实例设置配置
            httpDelete.setConfig(requestConfig);
            //执行请求
            CloseableHttpResponse response = client.execute(httpDelete);
            //获取Response状态码
            int statusCode = response.getStatusLine().getStatusCode();
            System.out.println(statusCode);
            //获取响应实体, 响应内容
            HttpEntity entity = response.getEntity();
            //通过EntityUtils中的toString方法将结果转换为字符串
            String str = EntityUtils.toString(entity);
            System.out.println(str);
            response.close();
            client.close();

            return str;

        } catch (URISyntaxException e) {
            throw new RuntimeException(e);
        } catch (ClientProtocolException e) {
            throw new RuntimeException(e);
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String sendDeleteBody(String token,String url,JSONObject jsonObject){
        try {
            //创建httpClient实例
            CloseableHttpClient client = HttpClients.createDefault();
            //创建一个uri对象
            URIBuilder uriBuilder = new URIBuilder(url);
            //创建远程连接实例,这里传入目标的网络地址
            HttpDeleteWithBody httpDelete = new HttpDeleteWithBody(uriBuilder.build());
            // 设置请求头信息，鉴权(没有可忽略)
            httpDelete.setHeader("Satoken", token);
            // 设置配置请求参数(没有可忽略)
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(60000)// 连接主机服务超时时间
                    .setConnectionRequestTimeout(60000)// 请求超时时间
                    .setSocketTimeout(60000)// 数据读取超时时间
                    .build();
            // 为实例设置配置
            httpDelete.setConfig(requestConfig);
            System.out.println(jsonObject);
            StringEntity reEntity = new StringEntity(jsonObject.toString(), Consts.UTF_8);
            reEntity.setContentType("application/json");
            httpDelete.setEntity(reEntity);

            //执行请求
            CloseableHttpResponse response = client.execute(httpDelete);
            //获取Response状态码
            int statusCode = response.getStatusLine().getStatusCode();
            System.out.println(statusCode);
            //获取响应实体, 响应内容
            HttpEntity entity = response.getEntity();
            //通过EntityUtils中的toString方法将结果转换为字符串
            String str = EntityUtils.toString(entity);
            System.out.println(str);
            response.close();
            client.close();

            return str;

        } catch (URISyntaxException e) {
            throw new RuntimeException(e);
        } catch (ClientProtocolException e) {
            throw new RuntimeException(e);
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String resultUtil(String re){
        //  System.out.println(re);
        JSONObject jsonObject=JSONObject.parseObject(re);
        if (jsonObject.get("code").toString().equals("200")){
            return jsonObject.get("data").toString();
        }else {
            throw new RuntimeException("调用接口异常："+re);
        }

    }
}
