package com.tongda.tdpimssdk.examples;

import com.tongda.tdpimssdk.entities.AssetAbstract;
import com.tongda.tdpimssdk.entities.Entity;
import com.tongda.tdpimssdk.entities.common.Catalog;
import com.tongda.tdpimssdk.entities.common.CatalogRoot;
import com.tongda.tdpimssdk.remote.RemoteTdPimHelper;
import com.tongda.tdpimssdk.remote.RemoteSaAuthHandler;
import com.tongda.tdpimssdk.resultVo.vo.GeneralPagerVo;

import java.util.List;

public class QuerySamples {

    public static void main(String[] args) {


        RemoteSaAuthHandler rsh = new RemoteSaAuthHandler("guantiantian","q1w2e3r4","121.199.160.117",9000);
        rsh.loginGetSaToken();
        rsh.serverIP ="150.158.75.213";
        rsh.serverPort=8080;
        rsh.dbName="TXPIMDB";

        //初始化远程查询对象
        RemoteTdPimHelper rqh = new RemoteTdPimHelper(rsh);

        CatalogRoot cr =  rqh.fetchAssetTemplates();
        System.out.println(
               "-------------------------------------------" + "\n" +
               "SDK queryAssetTemplates：" + "\n" +
               "-------------------------------------------"
        );
        for( int i =0; i<cr.getCatalog().size();i++){
            Catalog c = cr.getCatalog().get(i);
            System.out.println(c.getLabel());
            for(int j=0;j<c.getCatalog().size();j++){
                Catalog t = c.getCatalog().get(j);
                System.out.println("\t" + t.getLabel() + ", " + t.getIdRef());
            }
        }


        CatalogRoot cr1 =  rqh.fetchDocumentTemplates();
        System.out.println(
                "-------------------------------------------" + "\n" +
                "SDK queryDocumentTemplates：" + "\n" +
                "-------------------------------------------"
        );
        for( int i =0; i<cr1.getCatalog().size();i++){
            Catalog c = cr1.getCatalog().get(i);
            System.out.println(c.getLabel());
            for(int j=0;j<c.getCatalog().size();j++){
                Catalog t = c.getCatalog().get(j);
                System.out.println("\t" + t.getLabel() + ", " + t.getIdRef() + ", " + t.getId());
            }
        }


        List<Entity> le =  rqh.fetchAppConfigList("");
        System.out.println(
                "-------------------------------------------" + "\n" +
                "SDK getAppServiceList：" + "\n" +
                "-------------------------------------------"
        );
        for( int i =0; i<le.size();i++){
            Entity  e = le.get(i);
            System.out.println("\t" + e.getLabel() + ", " + e.getId());
        }

        GeneralPagerVo<AssetAbstract> ac =  rqh.fetchAssetByTemplate("ProductTemplate-1125744743611891712",1,20);
        System.out.println(
                "-------------------------------------------" + "\n" +
                "SDK queryAssetByTemplate：" + "\n" +
                "-------------------------------------------"
        );

        System.out.println("total: " + ac.getTotal());
        for( int i =0; i<ac.getData().size();i++){
            AssetAbstract  a = ac.getData().get(i);
            System.out.println("\t" + a.getLabel() + ", " + a.getId());
        }

        List<Entity> le2 = rqh.fetchAssetAppViewPath("Product-1126119026813042688");
        System.out.println(
                "-------------------------------------------" + "\n" +
                "SDK queryAssetAppViewPath：" + "\n" +
                "-------------------------------------------"
        );
        for( int i =0; i<le2.size();i++){
            Entity  e = le2.get(i);
            System.out.println("\t" + e.getLabel() + ", " + e.getId() + ", " + e.getInfo());
        }

    }
}
