package com.tongda.tdpimssdk.examples;

import com.alibaba.fastjson.JSONObject;
import com.tongda.tdpimssdk.remote.RemoteDocument;
import com.tongda.tdpimssdk.remote.RemoteSaAuthHandler;
import com.tongda.tdpimssdk.remote.RemoteTdPimHelper;
import com.tongda.tdpimssdk.resultVo.vo.AssetVo;

import java.io.File;
import java.util.LinkedList;
import java.util.List;

public class DocumentSamples {
    public static void main(String[] args) {
        RemoteSaAuthHandler rsh = new RemoteSaAuthHandler("guantiantian","q1w2e3r4","121.199.160.117",9000);
        rsh.loginGetSaToken();
//        rsh.serverIP ="127.0.0.1";
        rsh.serverIP ="150.158.75.213";
        rsh.serverPort=8080;
        rsh.dbName="TXPIMDB";

        //初始化远程查询对象
        RemoteTdPimHelper rqh = new RemoteTdPimHelper(rsh);

        String id=rqh.createDocument(JSONObject.parseObject(createDocument, AssetVo.class));
        System.out.println(
                "-------------------------------------------" + "\n" +
                        "SDK createAsset：" + "\n" +
                        "-------------------------------------------"
        );
        System.out.println("创建返回结果:"+id);

        RemoteDocument remoteDocument=rqh.fetchDocument(id);
        System.out.println(
                "-------------------------------------------" + "\n" +
                        "SDK fetchDocument：" + "\n" +
                        "-------------------------------------------"
        );
        System.out.println("查询文档:"+ remoteDocument.getId()+"/"+remoteDocument.getLabel()+"/"+remoteDocument.getDesc());

        //
        AssetVo assetVo=new AssetVo();
        assetVo.setId(id);
        AssetVo.AssetField assetField=new AssetVo.AssetField();
        assetField.setKey("td_asset_number");
        assetField.setMode("tdpim.dict.system.metadata.mode.single.value");
        assetField.setValue("test1234");
        List<AssetVo.AssetField> list=new LinkedList<>();
        //添加修改项，可以多个
        list.add(assetField);
        assetVo.setFields(list);
        //执行修改
        String re=rqh.updateDocumentValues(assetVo);
        System.out.println(
                "-------------------------------------------" + "\n" +
                        "SDK updateDocumentValues：" + "\n" +
                        "-------------------------------------------"
        );
        System.out.println("修改文档:"+re);

        re=rqh.deleteDocument(id);
        System.out.println(
                "-------------------------------------------" + "\n" +
                        "SDK deleteDocument：" + "\n" +
                        "-------------------------------------------"
        );
        System.out.println("删除文档:"+ re);

        File file=new File("C:\\Users\\zfn\\Desktop\\新建 文本文档1.txt");
        re=rqh.uploadBinary("Resource-1131278751615680512",file);
        System.out.println(
                "-------------------------------------------" + "\n" +
                        "SDK uploadBinary：" + "\n" +
                        "-------------------------------------------"
        );
        System.out.println("上传文档:"+ re);
    }


    public static String updateDocumentValues="{\n" +
            "  \"id\": \"Resource-1129783425285226496\",\n" +
            "  \"fields\": [\n" +
            "    {\n" +
            "      \"mode\": \"tdpim.dict.system.metadata.mode.single.value\",\n" +
            "      \"uom\": \"\",\n" +
            "      \"key\": \"td_asset_number\",\n" +
            "      \"value\": \"test1234\",\n" +
            "      \"valueMin\": null,\n" +
            "      \"valueMax\": null,\n" +
            "      \"selectedIDs\": null\n" +
            "    }\n" +
            "  ]\n" +
            "}";

    public static String createDocument="{\n" +
            "  \"templateID\": \"ResourceTemplate-1125740648473821184\",\n" +
            "  \"label\": \"测试7\",\n" +
            "  \"fields\": [\n" +
            "    {\n" +
            "      \"mode\": \"tdpim.dict.system.metadata.mode.single.value\",\n" +
            "      \"uom\": \"\",\n" +
            "      \"key\": \"td_asset_number\",\n" +
            "      \"value\": \"test123456789\",\n" +
            "      \"valueMin\": null,\n" +
            "      \"valueMax\": null,\n" +
            "      \"selectedIDs\": null\n" +
            "    },\n" +
            "    {\n" +
            "      \"mode\": \"tdpim.dict.system.metadata.mode.single.select.value\",\n" +
            "      \"uom\": \"\",\n" +
            "      \"key\": \"td_asset_subtype\",\n" +
            "      \"value\": \"安全设备\",\n" +
            "      \"valueMin\": null,\n" +
            "      \"valueMax\": null,\n" +
            "      \"selectedIDs\": null\n" +
            "    }\n" +
            "  ]\n" +
            "}";
}
