package com.tongda.tdpimssdk.examples;

import com.alibaba.fastjson.JSONObject;
import com.tongda.tdpimssdk.entities.AssetAbstract;
import com.tongda.tdpimssdk.remote.RemoteAsset;
import com.tongda.tdpimssdk.remote.RemoteSaAuthHandler;
import com.tongda.tdpimssdk.remote.RemoteTdPimHelper;
import com.tongda.tdpimssdk.resultVo.vo.AssetVo;

import java.util.LinkedList;
import java.util.List;

public class AssetSamples {

    public static void main(String[] args) {
        RemoteSaAuthHandler rsh = new RemoteSaAuthHandler("guantiantian","q1w2e3r4","121.199.160.117",9000);
        rsh.loginGetSaToken();
        rsh.serverIP ="150.158.75.213";
        rsh.serverPort=8080;
        rsh.dbName="TXPIMDB";
        System.out.println("登录数据"+rsh.toString());
        //初始化远程查询对象
        RemoteTdPimHelper rqh = new RemoteTdPimHelper(rsh);
        //创建资产
        String id=rqh.createAsset(JSONObject.parseObject(createAsset, AssetVo.class));
        System.out.println(
                "-------------------------------------------" + "\n" +
                "SDK createAsset：" + "\n" +
                "-------------------------------------------"
        );
        System.out.println("创建返回结果:"+id);

        //修改资产的数值
        AssetVo assetVo=new AssetVo();
        assetVo.setId(id);
        AssetVo.AssetField assetField=new AssetVo.AssetField();
        assetField.setKey("td_data_center");
        assetField.setMode("tdpim.dict.system.metadata.mode.single.select.value");
        assetField.setValue("北京一区");
        List<AssetVo.AssetField> list=new LinkedList<>();

        //添加修改项，可以多个
        list.add(assetField);
        assetVo.setFields(list);
        //执行修改
        String re=rqh.updateAssetValues(assetVo);

        System.out.println(
                "-------------------------------------------" + "\n" +
                        "SDK updateAssetValues：" + "\n" +
                        "-------------------------------------------"
        );
        System.out.println("修改返回结果:"+re);

        RemoteAsset  remoteAsset=rqh.fetchAsset(id);
        System.out.println(
                "-------------------------------------------" + "\n" +
                        "SDK fetchAsset：" + "\n" +
                        "-------------------------------------------"
        );
        System.out.println("查询资产:"+ remoteAsset.getId()+"/"+remoteAsset.getLabel()+"/"+remoteAsset.getDesc());

        re=rqh.deleteAsset(id);
        System.out.println(
                "-------------------------------------------" + "\n" +
                        "SDK deleteAsset：" + "\n" +
                        "-------------------------------------------"
        );
        System.out.println("删除资产:"+re);


    }

    public static String updateAsset="{\n" +
            "  \"id\": \"Product-1129487294932189184\",\n" +
            "  \"fields\": [\n" +
            "    {\n" +
            "      \"mode\": \"tdpim.dict.system.metadata.mode.single.select.value\",\n" +
            "      \"uom\": \"\",\n" +
            "      \"key\": \"td_data_center\",\n" +
            "      \"value\": \"北京一区\",\n" +
            "      \"valueMin\": null,\n" +
            "      \"valueMax\": null,\n" +
            "      \"selectedIDs\": null\n" +
            "    }\n" +
            "  ]\n" +
            "}";


    public static String createAsset="{\n" +
            "  \"templateID\": \"ProductTemplate-1110986502562643968\",\n" +
            "  \"label\": \"安全设备\",\n" +
            "  \"fields\": [\n" +
            "    {\n" +
            "      \"mode\": \"tdpim.dict.system.metadata.mode.single.value\",\n" +
            "      \"uom\": \"\",\n" +
            "      \"key\": \"td_asset_number\",\n" +
            "      \"value\": \"test\",\n" +
            "      \"valueMin\": null,\n" +
            "      \"valueMax\": null,\n" +
            "      \"selectedIDs\": null\n" +
            "    },\n" +
            "    {\n" +
            "      \"mode\": \"tdpim.dict.system.metadata.mode.single.value\",\n" +
            "      \"uom\": \"\",\n" +
            "      \"key\": \"td_asset_name\",\n" +
            "      \"value\": \"test\",\n" +
            "      \"valueMin\": null,\n" +
            "      \"valueMax\": null,\n" +
            "      \"selectedIDs\": null\n" +
            "    },\n" +
            "    {\n" +
            "      \"mode\": \"tdpim.dict.system.metadata.mode.single.select.value\",\n" +
            "      \"uom\": \"\",\n" +
            "      \"key\": \"td_asset_subtype\",\n" +
            "      \"value\": \"安全设备\",\n" +
            "      \"valueMin\": null,\n" +
            "      \"valueMax\": null,\n" +
            "      \"selectedIDs\": null\n" +
            "    },\n" +
            "    {\n" +
            "      \"mode\": \"tdpim.dict.system.metadata.mode.single.value\",\n" +
            "      \"uom\": \"\",\n" +
            "      \"key\": \"td_asset_serial_number\",\n" +
            "      \"value\": \"test\",\n" +
            "      \"valueMin\": null,\n" +
            "      \"valueMax\": null,\n" +
            "      \"selectedIDs\": null\n" +
            "    },\n" +
            "    {\n" +
            "      \"mode\": \"tdpim.dict.system.metadata.mode.single.value\",\n" +
            "      \"uom\": \"\",\n" +
            "      \"key\": \"td_asset_belong_project\",\n" +
            "      \"value\": \"test\",\n" +
            "      \"valueMin\": null,\n" +
            "      \"valueMax\": null,\n" +
            "      \"selectedIDs\": null\n" +
            "    },\n" +
            "    {\n" +
            "      \"mode\": \"tdpim.dict.system.metadata.mode.single.value\",\n" +
            "      \"uom\": \"\",\n" +
            "      \"key\": \"td_asset_desc\",\n" +
            "      \"value\": \"test\",\n" +
            "      \"valueMin\": null,\n" +
            "      \"valueMax\": null,\n" +
            "      \"selectedIDs\": null\n" +
            "    },\n" +
            "    {\n" +
            "      \"mode\": \"tdpim.dict.system.metadata.mode.single.select.value\",\n" +
            "      \"uom\": \"\",\n" +
            "      \"key\": \"td_data_center\",\n" +
            "      \"value\": \"\",\n" +
            "      \"valueMin\": null,\n" +
            "      \"valueMax\": null,\n" +
            "      \"selectedIDs\": null\n" +
            "    },\n" +
            "    {\n" +
            "      \"mode\": \"tdpim.dict.system.metadata.mode.single.value\",\n" +
            "      \"uom\": \"\",\n" +
            "      \"key\": \"td_asset_brand\",\n" +
            "      \"value\": \"\",\n" +
            "      \"valueMin\": null,\n" +
            "      \"valueMax\": null,\n" +
            "      \"selectedIDs\": null\n" +
            "    },\n" +
            "    {\n" +
            "      \"mode\": \"tdpim.dict.system.metadata.mode.single.value\",\n" +
            "      \"uom\": \"\",\n" +
            "      \"key\": \"td_asset_device_manufacturer\",\n" +
            "      \"value\": \"\",\n" +
            "      \"valueMin\": null,\n" +
            "      \"valueMax\": null,\n" +
            "      \"selectedIDs\": null\n" +
            "    },\n" +
            "    {\n" +
            "      \"mode\": \"tdpim.dict.system.metadata.mode.single.value\",\n" +
            "      \"uom\": \"\",\n" +
            "      \"key\": \"td_asset_model\",\n" +
            "      \"value\": \"\",\n" +
            "      \"valueMin\": null,\n" +
            "      \"valueMax\": null,\n" +
            "      \"selectedIDs\": null\n" +
            "    },\n" +
            "    {\n" +
            "      \"mode\": \"tdpim.dict.system.metadata.mode.single.value\",\n" +
            "      \"uom\": \"tdpim.dict.custom.uom.power.watt\",\n" +
            "      \"key\": \"rated_total_power\",\n" +
            "      \"value\": \"\",\n" +
            "      \"valueMin\": null,\n" +
            "      \"valueMax\": null,\n" +
            "      \"selectedIDs\": null\n" +
            "    },\n" +
            "    {\n" +
            "      \"mode\": \"tdpim.dict.system.metadata.mode.single.value\",\n" +
            "      \"uom\": \"tdpim.dict.custom.uom.quantity.u\",\n" +
            "      \"key\": \"device_u\",\n" +
            "      \"value\": \"\",\n" +
            "      \"valueMin\": null,\n" +
            "      \"valueMax\": null,\n" +
            "      \"selectedIDs\": null\n" +
            "    },\n" +
            "    {\n" +
            "      \"mode\": \"tdpim.dict.system.metadata.mode.single.value\",\n" +
            "      \"uom\": \"\",\n" +
            "      \"key\": \"td_asset_usage\",\n" +
            "      \"value\": \"\",\n" +
            "      \"valueMin\": null,\n" +
            "      \"valueMax\": null,\n" +
            "      \"selectedIDs\": null\n" +
            "    },\n" +
            "    {\n" +
            "      \"mode\": \"tdpim.dict.system.metadata.mode.single.select.value\",\n" +
            "      \"uom\": \"\",\n" +
            "      \"key\": \"asset_ownership_epartment\",\n" +
            "      \"value\": \"\",\n" +
            "      \"valueMin\": null,\n" +
            "      \"valueMax\": null,\n" +
            "      \"selectedIDs\": null\n" +
            "    },\n" +
            "    {\n" +
            "      \"mode\": \"tdpim.dict.system.metadata.mode.single.select.value\",\n" +
            "      \"uom\": \"\",\n" +
            "      \"key\": \"responsible_department\",\n" +
            "      \"value\": \"\",\n" +
            "      \"valueMin\": null,\n" +
            "      \"valueMax\": null,\n" +
            "      \"selectedIDs\": null\n" +
            "    },\n" +
            "    {\n" +
            "      \"mode\": \"tdpim.dict.system.metadata.mode.single.value\",\n" +
            "      \"uom\": \"\",\n" +
            "      \"key\": \"responsible_person_name\",\n" +
            "      \"value\": \"\",\n" +
            "      \"valueMin\": null,\n" +
            "      \"valueMax\": null,\n" +
            "      \"selectedIDs\": null\n" +
            "    },\n" +
            "    {\n" +
            "      \"mode\": \"tdpim.dict.system.metadata.mode.single.value\",\n" +
            "      \"uom\": \"\",\n" +
            "      \"key\": \"responsible_person_phone\",\n" +
            "      \"value\": \"\",\n" +
            "      \"valueMin\": null,\n" +
            "      \"valueMax\": null,\n" +
            "      \"selectedIDs\": null\n" +
            "    },\n" +
            "    {\n" +
            "      \"mode\": \"tdpim.dict.system.metadata.mode.single.value\",\n" +
            "      \"uom\": \"\",\n" +
            "      \"key\": \"responsible_person_email\",\n" +
            "      \"value\": \"\",\n" +
            "      \"valueMin\": null,\n" +
            "      \"valueMax\": null,\n" +
            "      \"selectedIDs\": null\n" +
            "    },\n" +
            "    {\n" +
            "      \"mode\": \"tdpim.dict.system.metadata.mode.single.select.value\",\n" +
            "      \"uom\": \"\",\n" +
            "      \"key\": \"td_procurement_get_method\",\n" +
            "      \"value\": \"\",\n" +
            "      \"valueMin\": null,\n" +
            "      \"valueMax\": null,\n" +
            "      \"selectedIDs\": null\n" +
            "    },\n" +
            "    {\n" +
            "      \"mode\": \"tdpim.dict.system.metadata.mode.single.value\",\n" +
            "      \"uom\": \"\",\n" +
            "      \"key\": \"td_purchase_quantity\",\n" +
            "      \"value\": \"\",\n" +
            "      \"valueMin\": null,\n" +
            "      \"valueMax\": null,\n" +
            "      \"selectedIDs\": null\n" +
            "    },\n" +
            "    {\n" +
            "      \"mode\": \"tdpim.dict.system.metadata.mode.single.value\",\n" +
            "      \"uom\": \"tdpim.dict.custom.uom.td_currency.cny.yuan\",\n" +
            "      \"key\": \"td_purchase_price\",\n" +
            "      \"value\": \"\",\n" +
            "      \"valueMin\": null,\n" +
            "      \"valueMax\": null,\n" +
            "      \"selectedIDs\": null\n" +
            "    },\n" +
            "    {\n" +
            "      \"mode\": \"tdpim.dict.system.metadata.mode.single.value\",\n" +
            "      \"uom\": \"tdpim.dict.custom.uom.td_currency.cny.yuan\",\n" +
            "      \"key\": \"td_purchase_amount\",\n" +
            "      \"value\": \"\",\n" +
            "      \"valueMin\": null,\n" +
            "      \"valueMax\": null,\n" +
            "      \"selectedIDs\": null\n" +
            "    },\n" +
            "    {\n" +
            "      \"mode\": \"tdpim.dict.system.metadata.mode.single.value\",\n" +
            "      \"uom\": \"\",\n" +
            "      \"key\": \"acquisition_date\",\n" +
            "      \"value\": \"\",\n" +
            "      \"valueMin\": null,\n" +
            "      \"valueMax\": null,\n" +
            "      \"selectedIDs\": null\n" +
            "    },\n" +
            "    {\n" +
            "      \"mode\": \"tdpim.dict.system.metadata.mode.single.value\",\n" +
            "      \"uom\": \"\",\n" +
            "      \"key\": \"original_contact_person\",\n" +
            "      \"value\": \"\",\n" +
            "      \"valueMin\": null,\n" +
            "      \"valueMax\": null,\n" +
            "      \"selectedIDs\": null\n" +
            "    },\n" +
            "    {\n" +
            "      \"mode\": \"tdpim.dict.system.metadata.mode.single.value\",\n" +
            "      \"uom\": \"\",\n" +
            "      \"key\": \"original_contact_factory\",\n" +
            "      \"value\": \"\",\n" +
            "      \"valueMin\": null,\n" +
            "      \"valueMax\": null,\n" +
            "      \"selectedIDs\": null\n" +
            "    },\n" +
            "    {\n" +
            "      \"mode\": \"tdpim.dict.system.metadata.mode.single.value\",\n" +
            "      \"uom\": \"\",\n" +
            "      \"key\": \"original_contact_phone\",\n" +
            "      \"value\": \"\",\n" +
            "      \"valueMin\": null,\n" +
            "      \"valueMax\": null,\n" +
            "      \"selectedIDs\": null\n" +
            "    },\n" +
            "    {\n" +
            "      \"mode\": \"tdpim.dict.system.metadata.mode.single.select.value\",\n" +
            "      \"uom\": \"\",\n" +
            "      \"key\": \"storage_warehouse\",\n" +
            "      \"value\": \"\",\n" +
            "      \"valueMin\": null,\n" +
            "      \"valueMax\": null,\n" +
            "      \"selectedIDs\": null\n" +
            "    },\n" +
            "    {\n" +
            "      \"mode\": \"tdpim.dict.system.metadata.mode.single.value\",\n" +
            "      \"uom\": \"\",\n" +
            "      \"key\": \"aircraft_building\",\n" +
            "      \"value\": \"\",\n" +
            "      \"valueMin\": null,\n" +
            "      \"valueMax\": null,\n" +
            "      \"selectedIDs\": null\n" +
            "    },\n" +
            "    {\n" +
            "      \"mode\": \"tdpim.dict.system.metadata.mode.single.value\",\n" +
            "      \"uom\": \"\",\n" +
            "      \"key\": \"machine_room\",\n" +
            "      \"value\": \"\",\n" +
            "      \"valueMin\": null,\n" +
            "      \"valueMax\": null,\n" +
            "      \"selectedIDs\": null\n" +
            "    },\n" +
            "    {\n" +
            "      \"mode\": \"tdpim.dict.system.metadata.mode.single.value\",\n" +
            "      \"uom\": \"\",\n" +
            "      \"key\": \"cabinet_number\",\n" +
            "      \"value\": \"\",\n" +
            "      \"valueMin\": null,\n" +
            "      \"valueMax\": null,\n" +
            "      \"selectedIDs\": null\n" +
            "    },\n" +
            "    {\n" +
            "      \"mode\": \"tdpim.dict.system.metadata.mode.single.value\",\n" +
            "      \"uom\": \"\",\n" +
            "      \"key\": \"service_area\",\n" +
            "      \"value\": \"\",\n" +
            "      \"valueMin\": null,\n" +
            "      \"valueMax\": null,\n" +
            "      \"selectedIDs\": null\n" +
            "    },\n" +
            "    {\n" +
            "      \"mode\": \"tdpim.dict.system.metadata.mode.single.value\",\n" +
            "      \"uom\": \"\",\n" +
            "      \"key\": \"service_start_date\",\n" +
            "      \"value\": \"\",\n" +
            "      \"valueMin\": null,\n" +
            "      \"valueMax\": null,\n" +
            "      \"selectedIDs\": null\n" +
            "    },\n" +
            "    {\n" +
            "      \"mode\": \"tdpim.dict.system.metadata.mode.single.select.value\",\n" +
            "      \"uom\": \"\",\n" +
            "      \"key\": \"operating_system\",\n" +
            "      \"value\": \"\",\n" +
            "      \"valueMin\": null,\n" +
            "      \"valueMax\": null,\n" +
            "      \"selectedIDs\": null\n" +
            "    },\n" +
            "    {\n" +
            "      \"mode\": \"tdpim.dict.system.metadata.mode.single.value\",\n" +
            "      \"uom\": \"\",\n" +
            "      \"key\": \"firmware_version\",\n" +
            "      \"value\": \"\",\n" +
            "      \"valueMin\": null,\n" +
            "      \"valueMax\": null,\n" +
            "      \"selectedIDs\": null\n" +
            "    },\n" +
            "    {\n" +
            "      \"mode\": \"tdpim.dict.system.metadata.mode.single.value\",\n" +
            "      \"uom\": \"\",\n" +
            "      \"key\": \"in_band_ip\",\n" +
            "      \"value\": \"\",\n" +
            "      \"valueMin\": null,\n" +
            "      \"valueMax\": null,\n" +
            "      \"selectedIDs\": null\n" +
            "    },\n" +
            "    {\n" +
            "      \"mode\": \"tdpim.dict.system.metadata.mode.single.value\",\n" +
            "      \"uom\": \"\",\n" +
            "      \"key\": \"out_band_ip\",\n" +
            "      \"value\": \"\",\n" +
            "      \"valueMin\": null,\n" +
            "      \"valueMax\": null,\n" +
            "      \"selectedIDs\": null\n" +
            "    },\n" +
            "    {\n" +
            "      \"mode\": \"tdpim.dict.system.metadata.mode.single.value\",\n" +
            "      \"uom\": \"\",\n" +
            "      \"key\": \"business_ip\",\n" +
            "      \"value\": \"\",\n" +
            "      \"valueMin\": null,\n" +
            "      \"valueMax\": null,\n" +
            "      \"selectedIDs\": null\n" +
            "    }\n" +
            "  ]\n" +
            "}";

}
