package com.tongda.tdtopo.util;

import com.alibaba.fastjson.JSONObject;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.Result;

import java.util.*;

public class GraphUtil {

    /**
     * neo4j返回结果 节点处理工具node
     * return m，n
     * @param result
     * @return
     */
    public static HashMap<String, JSONObject> nodesUtil(Result result){

        HashMap<String,JSONObject> hashMapNode=new HashMap<>();
        while (result.hasNext()) {
            Map<String,Object> row = result.next();
            for (Map.Entry<String,Object> column : row.entrySet()) {

                Node node=(Node)column.getValue();
                Iterator<Label> iterator=node.getLabels().iterator();
                ArrayList<String> arrayList=new ArrayList<>();
                while (iterator.hasNext()){
                    arrayList.add(iterator.next().toString());
                }
                JSONObject jsonObject=new JSONObject(node.getAllProperties());
                jsonObject.put("tags",arrayList);
                hashMapNode.put(column.getValue().toString(),jsonObject);
            }
        }
        return hashMapNode;
    }

    /**
     * neo4j返回结果 关系处理工具link
     * 适用此方法需要查询时设置关系的步长，默认可以为1，如[r*1],保证返回值中是一个list
     * return r
     * @param result
     * @return
     */
    public static ArrayList<JSONObject> linksUtil(Result result){
        ArrayList<JSONObject> relationList=new ArrayList<>();
        while (result.hasNext()) {
            Map<String,Object> row = result.next();
            for (Map.Entry<String,Object> column : row.entrySet()) {

                ArrayList<Relationship> arrayList=(ArrayList<Relationship>)column.getValue();
                for (Relationship relationship :arrayList){
                    JSONObject jsonObject1=new JSONObject();
                    jsonObject1.put("source",relationship.getStartNode().getAllProperties().get("id"));
                    jsonObject1.put("target",relationship.getEndNode().getAllProperties().get("id"));
                    jsonObject1.put("type",relationship.getType().toString());
                    relationList.add(jsonObject1);
                }
            }
        }
        return relationList;
    }

    /**
     * 步长为一的返回关系结果处理  r为1时
     * @param result
     * @return
     */
    public static JSONObject LinksAndNodesUtil(Result result){
//        System.out.println(result.resultAsString());
        ArrayList<JSONObject> relationList=new ArrayList<>();
        HashMap<String,JSONObject> hashMapNode=new HashMap<>();
        while (result.hasNext()) {
            Map<String,Object> row = result.next();
//            System.out.println(row.toString());
            for (Map.Entry<String,Object> column : row.entrySet()) {
//                System.out.println(column.toString());
                if (column.getKey().equals("r")){
//                    System.out.println(column.getValue());
                    List<Relationship> relationships=(List<Relationship>)column.getValue();
                    Relationship relationship=relationships.get(0);
                    JSONObject jsonObject1=new JSONObject();
                    jsonObject1.put("source",relationship.getStartNode().getProperty("id").toString());
                    jsonObject1.put("target",relationship.getEndNode().getProperty("id").toString());
                    jsonObject1.put("type",relationship.getType().toString());
                    relationList.add(jsonObject1);
                }else {
                    Node node=(Node)column.getValue();
                    Iterator<Label> iterator=node.getLabels().iterator();
                    ArrayList<String> arrayList=new ArrayList<>();
                    while (iterator.hasNext()){
                        arrayList.add(iterator.next().toString());
                    }
                    JSONObject jsonObject=new JSONObject(node.getAllProperties());
                    jsonObject.put("tags",arrayList);
                    hashMapNode.put(column.getValue().toString(),jsonObject);
                }
            }
        }
        ArrayList<JSONObject> nodeList = new ArrayList();
        Iterator iterator = hashMapNode.keySet().iterator();
        String s;
        while(iterator.hasNext()) {
            s = (String)iterator.next();
            JSONObject jsonObject = hashMapNode.get(s);
            nodeList.add(jsonObject);
        }

        JSONObject returnJson = new JSONObject();
        returnJson.put("nodes", nodeList);
        returnJson.put("links", relationList);
        return returnJson;
    }

}
