package com.tongda.tdtopo.neo4j;


import com.tongda.tdtopo.config.Neo4jProperties;
import com.tongda.tdtopo.config.RawConfigUtil;
import org.neo4j.graphdb.ConstraintViolationException;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseFactory;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.graphdb.schema.Schema;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;
import org.springframework.stereotype.Component;

import java.io.File;
import java.util.HashMap;


@Component
public class Neo4jServer {

    public static  GraphDatabaseService getGraphDatabaseServiceIn() {
        if (graphDatabaseService==null){
            graphDatabaseService = neo4jInit();
        }
        return graphDatabaseService;
    }
//    @Value("${neo4j.path}")
    public static String path= RawConfigUtil.getString("neo4j.path");

    public static  GraphDatabaseService graphDatabaseService=getGraphDatabaseServiceIn();

//    public static DatabaseManagementService managementService;

//    @Autowired
//    private Environment environment;

//    @PostConstruct
    public static GraphDatabaseService neo4jInit(){

        System.out.println("配置"+path+graphDatabaseService);
        if (path!=null&&graphDatabaseService==null){
            GraphDatabaseSettings.BoltConnector boltConnector = GraphDatabaseSettings.boltConnector( "0" );

            graphDatabaseService = new GraphDatabaseFactory()
                    .newEmbeddedDatabaseBuilder(new File(path))
//                .newEmbeddedDatabaseBuilder(new File("neo4j"))
                    .setConfig( GraphDatabaseSettings.pagecache_memory, "8192M" )
                    .setConfig( GraphDatabaseSettings.string_block_size, "600" )
                    .setConfig( GraphDatabaseSettings.array_block_size, "3000" )
//                .setConfig( boltConnector.type, "BOLT" )
//                .setConfig( boltConnector.enabled, "true" )
//                .setConfig( boltConnector.address, "localhost:7687")
                    .newGraphDatabase();
            System.out.println("neo4j-server启动");
            IndexDefinition indexDefinition;
            try ( Transaction tx = graphDatabaseService.beginTx() )
            {
                Schema schema = graphDatabaseService.schema();
                indexDefinition = schema.indexFor( Label.label( "MDE" ))
                        .on( "id" )
                        .create();
                indexDefinition = schema.indexFor( Label.label( "AST" ))
                        .on( "id" )
                        .create();
                tx.success();
            }catch (ConstraintViolationException e){
                System.out.println("index 已经建立");
            }
            return  graphDatabaseService;
        }
        System.out.println("初始化搁置");
        return null;
    }

//    private static void registerShutdownHook( final GraphDatabaseService graphDb )
//    {
//        // Registers a shutdown hook for the Neo4j instance so that it
//        // shuts down nicely when the VM exits (even if you "Ctrl-C" the
//        // running application).
//        Runtime.getRuntime().addShutdownHook( new Thread()
//        {
//            @Override
//            public void run()
//            {
//                graphDb.shutdown();
//            }
//        } );
//    }
//    @PostConstruct
//    public void init(){
//
//        Path of = Path.of(environment.getProperty("spring.neo4j.path"));
//            managementService = new DatabaseManagementServiceBuilder(of)
//                .setConfig( BoltConnector.enabled, true)
////                .setConfig( HttpConnector.enabled, true )
////                .setConfig( HttpConnector.listen_address, new SocketAddress(Integer.parseInt(environment.getProperty("spring.neo4j.port"))) )
//                .setConfig( BoltConnector.listen_address, new SocketAddress(Integer.parseInt(environment.getProperty("spring.neo4j.port"))))
////                .setConfig( GraphDatabaseSettings.auth_enabled,true)
////                .setConfig( GraphDatabaseSettings.data_directory,of)
//                .setConfig( GraphDatabaseSettings.initial_default_database,environment.getProperty("spring.data.neo4j.database"))
//                .setConfig(GraphDatabaseSettings.transaction_timeout, Duration.ofSeconds(60))
//                .build();
//        graphDatabaseService = managementService.database(environment.getProperty("spring.data.neo4j.database"));
//    }

}
