package com.tongda.tdtopo.auto;

import com.tongda.tdtopo.config.Neo4jProperties;
import com.tongda.tdtopo.neo4j.Neo4jServer;
import com.tongda.tdtopo.service.TDGraphService;
import lombok.Data;
import org.neo4j.graphdb.GraphDatabaseService;
import org.springframework.boot.autoconfigure.AutoConfigureOrder;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import javax.annotation.Resource;

@Configuration
@EnableConfigurationProperties(Neo4jProperties.class)
public class Neo4jAutoConfiguration {

    @Resource
    private Neo4jProperties properties; // 使用配置

    public Neo4jAutoConfiguration(Neo4jProperties properties) {
        this.properties = properties;
        this.init();
    }


    public void init() {
        //初始化neo4j
//        GraphDatabaseService graphDatabaseService=Neo4jServer.init(properties.getPath(),properties.getBolt());
//        Neo4jServer.path=properties.getPath();

        System.out.println(properties.getPath()+"/"+properties.getBolt());
//        Neo4jServer.neo4jInit();

//        System.out.println("neo4j-server启动成功");
//        TDGraphService tdGraphService=new TDGraphService();
//        System.out.println(tdGraphService.searchRelationType());

    }

}
