package com.yingxin.prms.service.schedule;

import com.yingxin.prms.domain.Server_Host_Info;
import com.yingxin.prms.dto.AuthModeAndHostList;
import com.yingxin.prms.service.asyncTask.AlarmTask;
import com.yingxin.prms.service.asyncTask.HttpTask;
import com.yingxin.prms.service.asyncTask.RedisTask;
import com.yingxin.prms.service.asyncTask.UdpTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import java.util.Date;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;

@Component
public class Schedule {

    private final HttpTask httpTask;

    private final UdpTask udpTask;

    private final RedisTask redisTask;

    private final AlarmTask alarmTask;

    private final AuthModeAndHostList list;

    private static Logger logger = LoggerFactory.getLogger(Schedule.class);
    @Autowired
    public Schedule(AuthModeAndHostList list, HttpTask httpTask, UdpTask udpTask, RedisTask redisTask, AlarmTask alarmTask) {
        this.list = list;
        this.httpTask = httpTask;
        this.udpTask = udpTask;
        this.redisTask = redisTask;
        this.alarmTask = alarmTask;
    }

    @Scheduled(initialDelay = 5000, fixedDelay = 10000)
    public void inspect() {
        logger.info("开始探测任务");
        ConcurrentHashMap<String, String> alarmHost = list.getAlarmHost();
        List<Server_Host_Info> server_host_infos = list.getClusterBeMonitoredList();
        for (Server_Host_Info hostInfo : server_host_infos) {
            if (hostInfo.getService_method().equals("post")) httpTask.doTask(hostInfo, alarmHost);
            if (hostInfo.getService_method().equals("get")) httpTask.doTask(hostInfo, alarmHost);
            if (hostInfo.getService_method().equals("udp")) udpTask.doTask(hostInfo, alarmHost);
            if (hostInfo.getService_method().equals("redis")) redisTask.doTask(hostInfo, alarmHost);
        }
    }
    @Scheduled(initialDelay = 60000, fixedDelay = 20000)
    public void alarm() {
        logger.info("开始告警判断");
        List<Server_Host_Info> server_host_infos = list.getClusterBeMonitoredList();
        for (Server_Host_Info hostInfo : server_host_infos) {
                alarmTask.doTask(hostInfo);
        }
    }
}
