package com.yingxin.prms.service.asyncTask;

import com.yingxin.prms.domain.Server_Host_Info;
import org.kairosdb.client.HttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;
import redis.clients.jedis.Jedis;

import java.util.concurrent.ConcurrentHashMap;

@Component
public class RedisTask extends BasicTask{

    private static Logger logger = LoggerFactory.getLogger(RedisTask.class);

    private final HttpClient httpClient;

    @Autowired
    public RedisTask(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    @Async("asyncTaskPool")
    public void doTask(Server_Host_Info hostInfo, ConcurrentHashMap<String, String> alarmHost) {
        long dur = 0;
        long start = System.currentTimeMillis();
        try (Jedis redisClient = new Jedis(hostInfo.getHost_ip(), hostInfo.getHost_port(), 300, 300)) {
            if (!hostInfo.getService_password().equals("null")) {
                redisClient.auth(hostInfo.getService_password());
            }
            String status = redisClient.info();
            alarmHost.remove(hostInfo.getService_path());
            dur = System.currentTimeMillis() - start;
            insertToKairos(httpClient,  hostInfo.getService_path(), dur, true);
        } catch (Exception e) {
            logger.info("error: redisTask to {}", hostInfo.getService_path());
            insertToKairos(httpClient,  hostInfo.getService_path(), dur, false);
        }
    }
}
