package com.yingxin.prms.domain;

import org.springframework.data.cassandra.core.mapping.Column;
import org.springframework.data.cassandra.core.mapping.PrimaryKey;
import org.springframework.data.cassandra.core.mapping.Table;

/**
 * Description:  告警记录
 * Datetime:    2020/10/21   13:16
 * Author:   gaozhentao
 */
@Table(value = "alarm_log")
public class AlarmLog {

    @PrimaryKey
    /* 告警序列号 */
    private String serialnum;

    private String ip;
    private String port;
    /* ok  正常   unstable 不稳定   down 宕机 */
    @Column("alarm_level")
    private String alarmLevel;
    /*  */
    @Column("alarm_message")
    private String alarmMessage;

    @Column("cluster_name")
    private String clusterName;
    /* 告警时间 */
    private String alatime;
    /* 恢复时间 */
    private String rectime;
    /* 1 告警   0  告警恢复   -1  告警发生变化*/
    private String state;

    public String getSerialnum() {
        return serialnum;
    }

    public void setSerialnum(String serialnum) {
        this.serialnum = serialnum;
    }

    public String getIp() {
        return ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public String getPort() {
        return port;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public String getAlarmLevel() {
        return alarmLevel;
    }

    public void setAlarmLevel(String alarmLevel) {
        this.alarmLevel = alarmLevel;
    }

    public String getAlarmMessage() {
        return alarmMessage;
    }

    public void setAlarmMessage(String alarmMessage) {
        this.alarmMessage = alarmMessage;
    }

    public String getAlatime() {
        return alatime;
    }

    public void setAlatime(String alatime) {
        this.alatime = alatime;
    }

    public String getRectime() {
        return rectime;
    }

    public void setRectime(String rectime) {
        this.rectime = rectime;
    }

    public String getState() {
        return state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getClusterName() {
        return clusterName;
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    @Override
    public String toString() {
        return "AlarmLog{" +
                "serialnum='" + serialnum + '\'' +
                ", ip='" + ip + '\'' +
                ", port='" + port + '\'' +
                ", alarmLevel='" + alarmLevel + '\'' +
                ", alarmMessage='" + alarmMessage + '\'' +
                ", clusterName='" + clusterName + '\'' +
                ", alatime='" + alatime + '\'' +
                ", rectime='" + rectime + '\'' +
                ", state='" + state + '\'' +
                '}';
    }
}
