package com.yingxin.prms.config.filter;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.config.annotation.*;



/**
 * 拦截器
 * 跨域请求支持/token拦截
 * tip:只能写在一个配置类里
 * @author gaozhentao
 * @version 1.0
 * @date 2020/08/31
 */
@Configuration
public class WebConfiguration implements WebMvcConfigurer {
    @Autowired
    private TokenInterceptor tokenInterceptor;

    /**
     * 配置静态访问资源
     * @param registry
     */
    @Override
    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        registry.addResourceHandler("/static/**").addResourceLocations("classpath:/static/");
    }


    @Override
    public void addCorsMappings(CorsRegistry registry) {
        registry.addMapping("/**")
                .allowCredentials(true)
                .allowedHeaders("*")
                .allowedMethods("*")
                .allowedOrigins("*");
    }

    @Override
    public void addInterceptors(InterceptorRegistry registry){
        registry.addInterceptor(tokenInterceptor)
                .addPathPatterns("/**")
                .excludePathPatterns("/css/**")
                .excludePathPatterns("/img/**")
                .excludePathPatterns("/js/**")
                .excludePathPatterns("/index.html")
                .excludePathPatterns("/rest/rel/login")
                .excludePathPatterns("/rest/rel/changeSwitch")
                .excludePathPatterns("/rest/rel/getSwitch");

        WebMvcConfigurer.super.addInterceptors(registry);
    }
}
