package com.yingxin.prms.config;

import com.yingxin.prms.dto.AuthModeAndHostList;
import com.yingxin.prms.service.dao.CassandraDaoImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import javax.annotation.PostConstruct;
import java.util.concurrent.ConcurrentHashMap;

@Configuration
public class InitAuthModeAndHostListConfig {

    private final CassandraDaoImpl cassandraDao;

    @Autowired
    public InitAuthModeAndHostListConfig(CassandraDaoImpl cassandraDao) {
        this.cassandraDao = cassandraDao;
    }

    @Bean
    @PostConstruct
    public AuthModeAndHostList initAuthModeAndHostList() {
        return new AuthModeAndHostList(
                cassandraDao.getAuthModeList(),
                cassandraDao.getRequestHostList(),
                cassandraDao.getProcessHostList(),
                cassandraDao.getClusterBeMonitoredList(),
                new ConcurrentHashMap<>()
        );
    }
}
