package com.yingxin.prms.api;

import com.yingxin.prms.domain.FlowLine;
import com.yingxin.prms.domain.FlowNode;
import com.yingxin.prms.service.business.Manager;
import net.sf.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.task.AsyncTaskExecutor;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.web.bind.annotation.*;

import java.util.HashMap;
import java.util.List;
import java.util.Map;


@RestController
@RequestMapping("/rest/rel")
@CrossOrigin(origins = "*")
public class ReliabilityApi {

    private final Manager manager;
    private final AsyncTaskExecutor taskExecutor;

    @Autowired
    public ReliabilityApi(Manager manager, AsyncTaskExecutor taskExecutor) {
        this.manager = manager;
        this.taskExecutor = taskExecutor;
    }

    /**
     * 2. 可靠性信息接口：所有集群的状态
     *
     * @return 集群信息json字符串
     */
    @GetMapping("selectClusterStatus")
    public Map selectClusterStatus() {
        return manager.selectClusterStatus();
    }

    @GetMapping("getThreadPoolStatus")
    public Map<String, Object> getThreadPoolStus() {
        ThreadPoolTaskExecutor executor = (ThreadPoolTaskExecutor)taskExecutor;
        int activeCount = executor.getActiveCount();
        int corePoolSize = executor.getCorePoolSize();
        int keepAliveSeconds = executor.getKeepAliveSeconds();
        int maxPoolSize = executor.getMaxPoolSize();
        int poolSize = executor.getPoolSize();
        Map<String, Object> map = new HashMap<>();
        map.put("activeCount", activeCount);
        map.put("corePoolSize", corePoolSize);
        map.put("keepAliveSeconds", keepAliveSeconds);
        map.put("maxPoolSize", maxPoolSize);
        map.put("poolSize", poolSize);
        return map;
    }

    @PostMapping("getAlarmLog")
    public Map<String, Object> getAlarmLog(@RequestBody String json) {
        return manager.getAlarmLog(json);
    }

    @PostMapping("login")
    public Map<String, Object> login(@RequestBody String json) {
        return manager.login(json);
    }

    @PostMapping("getToken")
    public Map<String, Object> getToken(@RequestBody String json) {
        return manager.getToken(json);
    }


    /**
     * 获取折线图
     *
     * @return 集群信息json字符串
     */
    @PostMapping("selectChart")
    public Map selectChart(@RequestBody String json) throws Exception{
        return manager.selectChart(json);
    }
    /**
     *  获取拓扑图数据
     *
     * @return
     */
    @GetMapping("selectTopology")
    public Map selectTopology(){
        return manager.selectTopology();
    }

    /**
     *  保存数据
     * @return
     */
    @PostMapping("saveTopology")
    public Map saveTopology(@RequestBody String json) {
        return manager.saveTopology(json);
    }
    /**
     *  获取认证量统计
     * @return
     */
    @GetMapping("getStatistics")
    public JSONObject getStatistics() {
        return manager.getStatistics();
    }

    /*
    * 微信告警开关
    * */
    @PostMapping("changeSwitch")
    public Map changeSwitch(@RequestBody String json) {
        return manager.changeSwitch(json);
    }
    /*
    * 获取微信告警开关状态
    * */
    @GetMapping("getSwitch")
    public Map getSwitch() {
        return manager.getSwitch();
    }

}
