package com.yingxin.prms.utils;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.yingxin.prms.dto.wx.AccessTokenRequset;
import com.yingxin.prms.dto.wx.AccessTokenResponse;
import com.yingxin.prms.dto.wx.WxResponseBean;
import org.apache.http.HttpEntity;
import org.apache.http.ParseException;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.ConnectException;
import java.net.SocketException;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Map;

/**
 * Description:
 * Datetime:    2020/12/1   16:15
 * Author:   gaozhentao
 */
public class SendHttpUtil {
    private static Logger logger = LoggerFactory.getLogger(SendHttpUtil.class);
    public static Map<String,String>   doGet(String uri) {
        Map<String,String>  map = new HashMap();
        // 获得Http客户端(可以理解为:你得先有一个浏览器;注意:实际上HttpClient与浏览器是不一样的)
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();

        // 参数
        StringBuffer params = new StringBuffer();

        // 创建Get请求
        HttpGet httpGet = new HttpGet(uri);
        // 响应模型
        CloseableHttpResponse response = null;
        try {
            // 配置信息
            RequestConfig requestConfig = RequestConfig.custom()
                    // 设置连接超时时间(单位毫秒)
                    .setConnectTimeout(5000)
//                    // 设置请求超时时间(单位毫秒)
//                    .setConnectionRequestTimeout(5000)
//                    // socket读写超时时间(单位毫秒)
//                    .setSocketTimeout(5000)
                    // 设置是否允许重定向(默认为true)
                    .setRedirectsEnabled(true).build();

            // 将上面的配置信息 运用到这个Get请求里
            httpGet.setConfig(requestConfig);

            // 由客户端执行(发送)Get请求
            response = httpClient.execute(httpGet);

            // 从响应模型中获取响应实体
            HttpEntity responseEntity = response.getEntity();
            map.put("status",String.valueOf(response.getStatusLine().getStatusCode()));
            if (responseEntity != null) {
                map.put("body",EntityUtils.toString(responseEntity));
            }
        }catch (ConnectException e){
            logger.error(uri+"请求超时"+" "+e.getMessage());
        }catch (ConnectTimeoutException e){
            logger.error(uri+"请求超时"+" "+e.getMessage());
        }catch (Exception e){
            logger.error(uri+"请求失败"+" "+e.getMessage());
        } finally {
            try {
                // 释放资源
                if (httpClient != null) {
                    httpClient.close();
                }
                if (response != null) {
                    response.close();
                }
            } catch (IOException e) {
                e.printStackTrace();
            }
            return map;
        }
    }

    public static Map<String,String>  doPost(String uri, String body) {
        Map<String,String> map = new HashMap();
        // 获得Http客户端(可以理解为:你得先有一个浏览器;注意:实际上HttpClient与浏览器是不一样的)
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        // 创建Post请求
        HttpPost httpPost = new HttpPost(uri);
        // 配置信息
        RequestConfig requestConfig = RequestConfig.custom()
                // 设置连接超时时间(单位毫秒)
                .setConnectTimeout(5000)
//                // 设置请求超时时间(单位毫秒)
//                .setConnectionRequestTimeout(3000)
//                // socket读写超时时间(单位毫秒)
//                .setSocketTimeout(3000)
//                // 设置是否允许重定向(默认为true)
                .setRedirectsEnabled(true).build();
        httpPost.setConfig(requestConfig);
        StringEntity entity = new StringEntity(body, "UTF-8");
        // post请求是将参数放在请求体里面传过去的;这里将entity放入post请求体中
        httpPost.setEntity(entity);

        httpPost.setHeader("Content-Type", "application/json;charset=utf8");

        // 响应模型
        CloseableHttpResponse response =null;
        HttpEntity responseEntity = null;
        try {
            // 由客户端执行(发送)Post请求
            response = httpClient.execute(httpPost);
            responseEntity = response.getEntity();
            map.put("status",String.valueOf(response.getStatusLine().getStatusCode()));

            if(responseEntity==null){
            }else{
                map.put("body",EntityUtils.toString(responseEntity, "utf-8"));
            }
            // 从响应模型中获取响应实体
        }catch (ConnectTimeoutException e){
            logger.error(uri+"连接超时"+" "+e.getMessage());
        } catch (ConnectException e){
            logger.error(uri+"请求超时"+" "+e.getMessage());
        } catch (Exception e){
            logger.error(uri+"请求失败"+" "+e.getMessage());
        }finally {
            try {
                // 释放资源
                if (httpClient != null) {
                    httpClient.close();
                }
                if (response != null) {
                    response.close();
                }

            } catch (IOException e) {
                e.printStackTrace();
            }
            return map;
        }
    }

    /**
     * 获取微信凭证
     * @param accessTokenRequset
     * @return
     */
    public static AccessTokenResponse getAccessToken(AccessTokenRequset accessTokenRequset) {
        try {
            String s = sendGet(accessTokenRequset.getAccessTokenUrl(), "corpid=" + accessTokenRequset.getCorpid() + "&corpsecret=" + accessTokenRequset.getCorpsecret());
            ObjectMapper mapper = new ObjectMapper();
            AccessTokenResponse accessTokenResponse = mapper.readValue(s, AccessTokenResponse.class);
            return accessTokenResponse;
        } catch (Exception e) {
            return null;
        }
    }
    /**
     * 发送信息
     * @param accessTokenResponse
     * @param sendjson
     * @return
     */
    public static WxResponseBean sendTextMessage(AccessTokenResponse accessTokenResponse, String sendjson) {

        ObjectMapper mapper = new ObjectMapper();
        String result = sendPost("https://qyapi.weixin.qq.com/cgi-bin/message/send?access_token=" + accessTokenResponse.getAccess_token(), sendjson);
        WxResponseBean wxResultMassage = new WxResponseBean();
        try {
            wxResultMassage = mapper.readValue(result, WxResponseBean.class);
        } catch (JsonParseException e) {
            e.printStackTrace();
        } catch (JsonMappingException e) {
            e.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        }
        return wxResultMassage;

    }
    /**
     * 与微信服务建立连接
     *
     * @param url   请求地址
     * @param param 请求参数
     * @return
     */
    public static String sendGet(String url, String param) {
        String result = "";
        BufferedReader in = null;
        try {
            String urlNameString = url + "?" + param;
            URL realUrl = new URL(urlNameString);
            // 打开和URL之间的连接
            URLConnection connection = realUrl.openConnection();
            //URL设置超时时间
            connection.setConnectTimeout(1000);
            connection.setReadTimeout(1000);
            // 设置通用的请求属性
            connection.setRequestProperty("accept", "*/*");
            connection.setRequestProperty("connection", "Keep-Alive");
            connection.setRequestProperty("user-agent",
                    "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1;SV1)");
            // 建立实际的连接
            connection.connect();

            // 获取所有响应头字段
//            Map<String, List<String>> map = connection.getHeaderFields();
//            // 遍历所有的响应头字段
//            for (String key : map.keySet()) {
//                System.out.println(key + "--->" + map.get(key));
//            }
            // 定义 BufferedReader输入流来读取URL的响应
            in = new BufferedReader(new InputStreamReader(
                    connection.getInputStream()));
            String line;
            while ((line = in.readLine()) != null) {
                result += line;
            }
        } catch (Exception e) {
            logger.error("发送GET请求出现异常！" + e);
        }
        // 使用finally块来关闭输入流
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            } catch (Exception e2) {
                e2.printStackTrace();
            }
        }
        return result;
    }


    /**
     * 向指定 URL 发送POST方法的请求
     *
     * @param url   发送请求的 URL
     * @param param 请求参数，请求参数应该是 name1=value1&name2=value2 的形式。
     * @return 所代表远程资源的响应结果
     */
    public static String sendPost(String url, String param) {
        PrintWriter out = null;
        BufferedReader in = null;
        String result = "";
        try {
            URL realUrl = new URL(url);
            // 打开和URL之间的连接
            URLConnection conn = realUrl.openConnection();
            // 设置通用的请求属性
            conn.setRequestProperty("accept", "*/*");
            conn.setRequestProperty("connection", "Keep-Alive");
            conn.setRequestProperty("user-agent",
                    "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1;SV1)");
            // 发送POST请求必须设置如下两行
            conn.setDoOutput(true);
            conn.setDoInput(true);
            // 获取URLConnection对象对应的输出流
            out = new PrintWriter(conn.getOutputStream());
            // 发送请求参数
            out.print(param);
            // flush输出流的缓冲
            out.flush();
            // 定义BufferedReader输入流来读取URL的响应
            in = new BufferedReader(
                    new InputStreamReader(conn.getInputStream()));
            String line;
            while ((line = in.readLine()) != null) {
                result += line;
            }
        } catch (Exception e) {
            System.out.println("发送 POST 请求出现异常！" + e);
            e.printStackTrace();
        }
        //使用finally块来关闭输出流、输入流
        finally {
            try {
                if (out != null) {
                    out.close();
                }
                if (in != null) {
                    in.close();
                }
            } catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        return result;
    }

}
