package com.yingxin.prms.service.asyncTask;

import org.apache.http.impl.client.HttpClientBuilder;
import org.kairosdb.client.HttpClient;
import org.kairosdb.client.builder.*;
import org.kairosdb.client.response.GetResponse;
import org.kairosdb.client.response.QueryResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.util.List;

public class BasicTask {

    private static Logger logger = LoggerFactory.getLogger(BasicTask.class);

    /**
     * 服务运行状态添加到kairosDB数据库
     * @param client
     * @param url
     * @param dur
     * @param isAlive
     */
    Boolean insertToKairos(HttpClient client, String url, long dur, boolean isAlive) {

        boolean ss=false;
        MetricBuilder builderHeartbeat = MetricBuilder.getInstance();
        builderHeartbeat.addMetric("heartbeat")
                .addTag("host", url)
                .addDataPoint(System.currentTimeMillis(), isAlive ? 0 : 1).addTtl(172800); //172800=48小时
        MetricBuilder builderRespDur = MetricBuilder.getInstance();
        builderRespDur.addMetric("respdur")
                .addTag("host", url)
                .addDataPoint(System.currentTimeMillis(), dur);
        try {
            client.pushMetrics(builderHeartbeat);
            if (isAlive) {
                client.pushMetrics(builderRespDur);
            }
            ss=true;
        } catch (IOException e) {
            logger.error("error in insertToKairos.{}:{}",url);
            logger.error(e.getMessage());
        }
        return ss;
    }



    void getKairos(HttpClient client, String ip, int port, long dur, boolean isAlive) {



//        builderHeartbeat.addMetric("heartbeat")
//                .addTag("host", ip + ":" + port)
//                .addDataPoint(System.currentTimeMillis(), isAlive ? 0 : 1).addTtl(172800); //172800=48小时
//        MetricBuilder builderRespDur = MetricBuilder.getInstance();
//        builderRespDur.addMetric("respdur")
//                .addTag("host", ip + ":" + port)
//                .addDataPoint(System.currentTimeMillis(), dur);
//        try {
//            client.pushMetrics(builderHeartbeat);
//            if (isAlive) {
//                client.pushMetrics(builderRespDur);
//            }
//            ss=true;
//        } catch (IOException e) {
//            logger.error("error in insertToKairos.{}:{}", ip, port);
//            logger.error(e.getMessage());
//        }
//        return ss;
    }

}
