package com.yingxin.prms.config;

import com.yingxin.prms.domain.ServiceNameUpdate;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 拓扑图服务名称修改对照表
 * Created by shao on 2021/7/17.
 */
@Configuration
public class ServiceNameConfig {
    @Bean
    public List<ServiceNameUpdate> getServiceNameList(){
        List<ServiceNameUpdate> snus = new ArrayList<>();
        snus.add(new ServiceNameUpdate("公安网用户","公安网用户"));
        snus.add(new ServiceNameUpdate("公安网vpn用户","公安网vpn用户"));
        snus.add(new ServiceNameUpdate("token核验服务","token核验服务"));
        snus.add(new ServiceNameUpdate("token方式接入服务","token方式接入服务"));
        snus.add(new ServiceNameUpdate("签名验签接入服务","签名验签接入服务"));
        snus.add(new ServiceNameUpdate("签名服务器","签名服务器"));
        snus.add(new ServiceNameUpdate("VPN方式接入服务","VPN方式接入服务"));
        snus.add(new ServiceNameUpdate("权限核验服务facl","权限核验facl"));
        snus.add(new ServiceNameUpdate("mysql","mysql组件"));
        snus.add(new ServiceNameUpdate("redis","redis组件"));
        snus.add(new ServiceNameUpdate("平台业务权限配置管理服务","业务权限配置"));
        snus.add(new ServiceNameUpdate("账户应用管理服务","账户管理服务"));
        snus.add(new ServiceNameUpdate("平台业务实时统计服务","业务统计服务"));
        snus.add(new ServiceNameUpdate("平台运营管理","平台运营管理"));
        snus.add(new ServiceNameUpdate("核心调度服务","核心调度服务"));
        snus.add(new ServiceNameUpdate("核心业务区","核心业务区"));
        snus.add(new ServiceNameUpdate("身份核查（两张图片）","照片比对（1对1）"));
        snus.add(new ServiceNameUpdate("身份核查（身份证号+人脸）","身份核查（人证）"));
        snus.add(new ServiceNameUpdate("以图查人（基础库）","实时人员身份识别"));
        snus.add(new ServiceNameUpdate("M:N","聚档人员实名化"));
        snus.add(new ServiceNameUpdate("以图查人（特殊人员库）","以图查人-专题库"));
        snus.add(new ServiceNameUpdate("算法区","算法区"));
        snus.add(new ServiceNameUpdate("算法融合调度","算法融合调度"));
        snus.add(new ServiceNameUpdate("1比1比对（特征+特征）","人脸识别引擎1"));
        snus.add(new ServiceNameUpdate("1比1比对(图片+图片)","人脸识别引擎2"));
        snus.add(new ServiceNameUpdate("1比N比对（图片）","人脸识别引擎3"));
        snus.add(new ServiceNameUpdate("图片生成特征值","图像质量评估引擎"));
        snus.add(new ServiceNameUpdate("1比1比对(图片+特征)","指纹识别引擎"));
        snus.add(new ServiceNameUpdate("M比N","虹膜识别引擎"));
        snus.add(new ServiceNameUpdate("1比N比对(特征)","OCR识别引擎"));
        snus.add(new ServiceNameUpdate("消息队列","算法融合调度"));
        snus.add(new ServiceNameUpdate("日志采集服务","日志汇聚服务"));
        return snus;
    }

    @Bean
    public Map<String,String> getServiceName(){
        Map<String,String> serviceName = new HashMap<>();
        serviceName.put("公安网用户","公安网用户");
        serviceName.put("公安网vpn用户","公安网vpn用户");
        serviceName.put("token核验服务","token核验服务");
        serviceName.put("token方式接入服务","token方式接入服务");
        serviceName.put("签名验签接入服务","签名验签接入服务");
        serviceName.put("签名服务器","签名服务器");
        serviceName.put("VPN方式接入服务","VPN方式接入服务");
        serviceName.put("权限核验服务facl","权限核验facl");
        serviceName.put("mysql","mysql组件");
        serviceName.put("redis","redis组件");
        serviceName.put("平台业务权限配置管理服务","业务权限配置");
        serviceName.put("账户应用管理服务","账户管理服务");
        serviceName.put("平台业务实时统计服务","业务统计服务");
        serviceName.put("平台运营管理","平台运营管理");
        serviceName.put("核心调度服务","核心调度服务");
        serviceName.put("核心业务区","核心业务区");
        serviceName.put("身份核查（两张图片）","照片比对（1对1）");
        serviceName.put("身份核查（身份证号+人脸）","身份核查（人证）");
        serviceName.put("以图查人（基础库）","实时人员身份识别");
        serviceName.put("M:N","聚档人员实名化");
        serviceName.put("以图查人（特殊人员库）","以图查人-专题库");
        serviceName.put("算法区","算法区");
        serviceName.put("算法融合调度","算法融合调度");
        serviceName.put("1比1比对（特征+特征）","人脸识别引擎1");
        serviceName.put("1比1比对(图片+图片)","人脸识别引擎2");
        serviceName.put("1比N比对（图片）","人脸识别引擎3");
        serviceName.put("图片生成特征值","图像质量评估引擎");
        serviceName.put("1比1比对(图片+特征)","指纹识别引擎");
        serviceName.put("M比N","虹膜识别引擎");
        serviceName.put("1比N比对(特征)","OCR识别引擎");
        serviceName.put("消息队列","算法融合调度");
        serviceName.put("日志采集服务","日志汇聚服务");
        //TODO  备份保存
//        serviceName.put("公安网用户","公安网用户");
//        serviceName.put("公安网vpn用户","公安网vpn用户");
//        serviceName.put("token核验服务","token核验服务");
//        serviceName.put("token方式接入服务","token方式接入服务");
//        serviceName.put("签名验签接入服务","签名验签接入服务");
//        serviceName.put("签名服务器","签名服务器");
//        serviceName.put("VPN方式接入服务","VPN方式接入服务");
//        serviceName.put("权限核验服务facl","权限核验facl");
//        serviceName.put("mysql","mysql组件");
//        serviceName.put("redis","redis组件");
//        serviceName.put("平台业务权限配置管理服务","业务权限配置");
//        serviceName.put("账户应用管理服务","账户管理服务");
//        serviceName.put("平台业务实时统计服务","业务统计服务");
//        serviceName.put("平台运营管理","平台运营管理");
//        serviceName.put("核心调度服务","核心调度服务");
//        serviceName.put("核心业务区","核心业务区");
//        serviceName.put("身份核查（两张图片）","照片比对（1对1）");
//        serviceName.put("身份核查（身份证号+人脸）","身份核查（人证）");
//        serviceName.put("以图查人（基础库）","实时人员身份识别");
//        serviceName.put("M:N","聚档人员实名化");
//        serviceName.put("以图查人（特殊人员库）","以图查人-专题库");
//        serviceName.put("算法区","算法区");
//        serviceName.put("算法融合调度","算法融合调度");
//        serviceName.put("1比1比对（特征+特征）","人脸识别引擎1");
//        serviceName.put("1比1比对(图片+图片)","人脸识别引擎2");
//        serviceName.put("1比N比对（图片）","人脸识别引擎3");
//        serviceName.put("图片生成特征值","图像质量评估引擎");
//        serviceName.put("1比1比对(图片+特征)","指纹识别引擎");
//        serviceName.put("M比N","虹膜识别引擎");
//        serviceName.put("1比N比对(特征)","OCR识别引擎");
//        serviceName.put("消息队列","算法融合调度");
//        serviceName.put("日志采集服务","日志汇聚服务");
        return serviceName;
    }
}
