package com.yingxin.prms.api;

import com.yingxin.prms.service.business.Manager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.ws.rs.*;
import javax.ws.rs.core.MediaType;
import java.util.List;


@RestController
@RequestMapping("/rest/perf")
@CrossOrigin(origins = "*")
public class PerformanceApi {

    private final Manager manager;

    @Autowired
    public PerformanceApi(Manager manager) {
        this.manager = manager;
    }


    /**
     * 查询第二个包的ip和port
     *
     * @return 返回 JSON（查询结果及查询条件）
     */
    @GetMapping("selectSecondIpAndPort")
    public List selectSecondIpAndPort() {
        return manager.selectSecondIpAndPort();
    }

//    @GET
//    @Path("reqBLV")
//    @Produces(MediaType.APPLICATION_JSON)
//    public List<CTID_Request_Perf_BaseLineValue> getReqBLV() {
//        return manager.getReqBLV();
//    }
//
//    @GET
//    @Path("proBLV")
//    @Produces(MediaType.APPLICATION_JSON)
//    public List<CTID_Process_Perf_BaseLineValue> getProBLV() {
//        return manager.getProBLV();
//    }
//
//    @POST
//    @Path("updateReqBLV")
//    @Consumes(MediaType.APPLICATION_JSON)
//    @Produces(MediaType.APPLICATION_JSON)
//    public List<CTID_Request_Perf_BaseLineValue> saveReqBLV(CTID_Request_Perf_BaseLineValue entity) {
//        return manager.updateReqBLV(entity);
//    }
//
//    @POST
//    @Path("updateProBLV")
//    @Consumes(MediaType.APPLICATION_JSON)
//    @Produces(MediaType.APPLICATION_JSON)
//    public List<CTID_Process_Perf_BaseLineValue> saveReqBLV(CTID_Process_Perf_BaseLineValue entity) {
//        return manager.updateProBLV(entity);
//    }
}
