package com.yingxin.prms.service.dao;

import com.yingxin.prms.config.Constant;
import com.yingxin.prms.domain.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.cassandra.core.CassandraTemplate;
import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.Map;


@Repository
public class CassandraDaoImpl {

    private final CassandraTemplate template;

    @Autowired
    public CassandraDaoImpl(CassandraTemplate template) {
        this.template = template;
    }


    public List<Auth_Mode_Dic> getAuthModeList() {
        return template.select("select * from ctid_prof.auth_mode_dic;", Auth_Mode_Dic.class);
    }

    public List<CTID_Request_Host_Dic> getRequestHostList() {
        return template.select("select * from ctid_prof.ctid_request_host_dic;", CTID_Request_Host_Dic.class);
    }

    public List<CTID_Process_Host_Dic> getProcessHostList() {
        return template.select("select * from ctid_prof.ctid_process_host_dic;", CTID_Process_Host_Dic.class);
    }

    public List<Server_Host_Info> getClusterBeMonitoredList() {
        return template.select("select * from ctid_prof.server_host_info;", Server_Host_Info.class);
    }

    public void saveReqBLV(CTID_Request_Perf_BaseLineValue entity) {
        template.insert(entity);
    }

    public void saveProBLV(CTID_Process_Perf_BaseLineValue entity) {
        template.insert(entity);
    }

//    public List<CTID_Request_Perf_BaseLineValue> getReqBLV() {
//        return template.select("select * from ctid_prof.ctid_request_perf_base_line_value;", CTID_Request_Perf_BaseLineValue.class);
//    }
//
//    public List<CTID_Process_Perf_BaseLineValue> getProBLV() {
//        return template.select("select * from ctid_prof.ctid_process_perf_base_line_value;", CTID_Process_Perf_BaseLineValue.class);
//    }

    public List<AlarmLog> getAlarmLog(int size,String flag) {
        String cql="select * from ctid_prof.alarm_log where token(serialnum) > token( '"+flag+"' ) and state < '"+Constant.ALARM_ING+"' limit "+size+ " allow filtering;";
        return template.select(cql, AlarmLog.class);
    }

    public List<AlarmLog> getAlarmList() {
        String cql="select * from ctid_prof.alarm_log where state = '" +Constant.ALARM_ING+"' allow filtering";
        return template.select(cql, AlarmLog.class);
    }

    public AlarmLog checkAlarm(String name,String ip,String port) {
        String cql="select * from ctid_prof.alarm_log where cluster_name = '"+name+"' and ip = '"+ip+"' and port = '"+port+"' and state = '" +Constant.ALARM_ING+"' allow filtering";
        return template.selectOne(cql, AlarmLog.class);
    }

    public boolean updateAlarm(String serialnum,String time) {
        String cql="update ctid_prof.alarm_log set rectime = '"+time+"' , state = '" +Constant.ALARM_RECOVERY +"', alarm_level = '"+Constant.ALARM_OK+"' where serialnum = '"+serialnum +"'";
        return template.getCqlOperations().execute(cql);
    }
    public void insertAlarm(AlarmLog alarmLog) {
        String cql ="INSERT INTO ctid_prof.alarm_log (serialnum, alarm_level, alarm_message, alatime, cluster_name, ip, port, rectime, state)" +
                "VALUES('"+alarmLog.getSerialnum()+"', '"+alarmLog.getAlarmLevel()+"', '"+alarmLog.getAlarmMessage()+"', '"+alarmLog.getAlatime()+"', '"+alarmLog.getClusterName()+"', '"+alarmLog.getIp()+"', '"+alarmLog.getPort()+"', '"+alarmLog.getRectime()+"', '"+alarmLog.getState()+"');";
        template.getCqlOperations().execute(cql);
    }
    public Map getAlarmLogSize() {
        String cql="select count(*) from ctid_prof.alarm_log where state < '" +Constant.ALARM_ING+"' allow filtering";
        return template.selectOne(cql,Map.class);
    }

    public Admin findByUsername(String username) {
        String cql = "SELECT *  FROM ctid_prof.admin where username = '"+username+"';";
        return template.selectOne(cql,Admin.class);
    }

    public Server_Host_Info findHostInfo(String url) {
        String cql ="select * from ctid_prof.server_host_info where service_path = '"+url+"' allow filtering;;";
        return template.selectOne(cql, Server_Host_Info.class);
    }

    public Server_Host_Info getStatisticsUri() {
        String cql = "select * from server_host_info where cluster_name = '平台业务实时统计服务' allow filtering";
        return template.selectOne(cql, Server_Host_Info.class);
    }
}
