package com.yingxin.prms.dto;

import com.yingxin.prms.domain.CTID_Process_Perf;

import java.util.List;

public class ProcessPerformance {

    private int dur_after_all_decrypt;

    private int dur_auth_code_decrypt;

    private int dur_before_auth_decrypt;

    private int dur_bizpackage_sign;

    private int dur_challenge;

    private int dur_decrypt_total;

    private int dur_dn;

    private int dur_dn_data2;

    private int dur_dn_data4;

    private int dur_id_data2;

    private int dur_id_data4;

    private int dur_id_decrypt;

    private int dur_log_nd;

    private int dur_log_yx;

    private int dur_mode_check;

    private int dur_mode_count;

    private int dur_parallel_auth;

    private int dur_pic;

    private int dur_pic_data2;

    private int dur_pic_data4;

    private int dur_pic_decrypt;

    private int dur_public_power;

    private int dur_query_cache_mode;

    private int dur_retain_decrypt;

    private int dur_sign_verify;

    private int dur_total;

    private int dur_voucher;

    private int dur_voucher_data4;

    public ProcessPerformance() {
    }

    public ProcessPerformance(List<CTID_Process_Perf> perfs) {
        if (perfs.size() == 0) return;
        getAvgPerf(perfs);
    }

    private void getAvgPerf(List<CTID_Process_Perf> perfs) {
        this.dur_after_all_decrypt = perfs.stream().mapToInt(CTID_Process_Perf::getDur_after_all_decrypt).sum() / perfs.size();
        this.dur_auth_code_decrypt = perfs.stream().mapToInt(CTID_Process_Perf::getDur_auth_code_decrypt).sum() / perfs.size();
        this.dur_before_auth_decrypt = perfs.stream().mapToInt(CTID_Process_Perf::getDur_before_auth_decrypt).sum() / perfs.size();
        this.dur_bizpackage_sign = perfs.stream().mapToInt(CTID_Process_Perf::getDur_bizpackage_sign).sum() / perfs.size();
        this.dur_challenge = perfs.stream().mapToInt(CTID_Process_Perf::getDur_challenge).sum() / perfs.size();
        this.dur_decrypt_total = perfs.stream().mapToInt(CTID_Process_Perf::getDur_decrypt_total).sum() / perfs.size();
        this.dur_dn = perfs.stream().mapToInt(CTID_Process_Perf::getDur_dn).sum() / perfs.size();
        this.dur_dn_data2 = perfs.stream().mapToInt(CTID_Process_Perf::getDur_dn_data2).sum() / perfs.size();
        this.dur_dn_data4 = perfs.stream().mapToInt(CTID_Process_Perf::getDur_dn_data4).sum() / perfs.size();
        this.dur_id_data2 = perfs.stream().mapToInt(CTID_Process_Perf::getDur_id_data2).sum() / perfs.size();
        this.dur_id_data4 = perfs.stream().mapToInt(CTID_Process_Perf::getDur_id_data4).sum() / perfs.size();
        this.dur_id_decrypt = perfs.stream().mapToInt(CTID_Process_Perf::getDur_id_decrypt).sum() / perfs.size();
        this.dur_log_nd = perfs.stream().mapToInt(CTID_Process_Perf::getDur_log_nd).sum() / perfs.size();
        this.dur_log_yx = perfs.stream().mapToInt(CTID_Process_Perf::getDur_log_yx).sum() / perfs.size();
        this.dur_mode_check = perfs.stream().mapToInt(CTID_Process_Perf::getDur_mode_check).sum() / perfs.size();
        this.dur_mode_count = perfs.stream().mapToInt(CTID_Process_Perf::getDur_mode_count).sum() / perfs.size();
        this.dur_parallel_auth = perfs.stream().mapToInt(CTID_Process_Perf::getDur_parallel_auth).sum() / perfs.size();
        this.dur_pic = perfs.stream().mapToInt(CTID_Process_Perf::getDur_pic).sum() / perfs.size();
        this.dur_pic_data2 = perfs.stream().mapToInt(CTID_Process_Perf::getDur_pic_data2).sum() / perfs.size();
        this.dur_pic_data4 = perfs.stream().mapToInt(CTID_Process_Perf::getDur_pic_data4).sum() / perfs.size();
        this.dur_pic_decrypt = perfs.stream().mapToInt(CTID_Process_Perf::getDur_pic_decrypt).sum() / perfs.size();
        this.dur_public_power = perfs.stream().mapToInt(CTID_Process_Perf::getDur_public_power).sum() / perfs.size();
        this.dur_query_cache_mode = perfs.stream().mapToInt(CTID_Process_Perf::getDur_query_cache_mode).sum() / perfs.size();
        this.dur_retain_decrypt = perfs.stream().mapToInt(CTID_Process_Perf::getDur_retain_decrypt).sum() / perfs.size();
        this.dur_sign_verify = perfs.stream().mapToInt(CTID_Process_Perf::getDur_sign_verify).sum() / perfs.size();
        this.dur_total = perfs.stream().mapToInt(CTID_Process_Perf::getDur_total).sum() / perfs.size();
        this.dur_voucher = perfs.stream().mapToInt(CTID_Process_Perf::getDur_voucher).sum() / perfs.size();
        this.dur_voucher_data4 = perfs.stream().mapToInt(CTID_Process_Perf::getDur_voucher_data4).sum() / perfs.size();
    }

    public int getDur_after_all_decrypt() {
        return dur_after_all_decrypt;
    }

    public void setDur_after_all_decrypt(int dur_after_all_decrypt) {
        this.dur_after_all_decrypt = dur_after_all_decrypt;
    }

    public int getDur_auth_code_decrypt() {
        return dur_auth_code_decrypt;
    }

    public void setDur_auth_code_decrypt(int dur_auth_code_decrypt) {
        this.dur_auth_code_decrypt = dur_auth_code_decrypt;
    }

    public int getDur_before_auth_decrypt() {
        return dur_before_auth_decrypt;
    }

    public void setDur_before_auth_decrypt(int dur_before_auth_decrypt) {
        this.dur_before_auth_decrypt = dur_before_auth_decrypt;
    }

    public int getDur_bizpackage_sign() {
        return dur_bizpackage_sign;
    }

    public void setDur_bizpackage_sign(int dur_bizpackage_sign) {
        this.dur_bizpackage_sign = dur_bizpackage_sign;
    }

    public int getDur_challenge() {
        return dur_challenge;
    }

    public void setDur_challenge(int dur_challenge) {
        this.dur_challenge = dur_challenge;
    }

    public int getDur_decrypt_total() {
        return dur_decrypt_total;
    }

    public void setDur_decrypt_total(int dur_decrypt_total) {
        this.dur_decrypt_total = dur_decrypt_total;
    }

    public int getDur_dn() {
        return dur_dn;
    }

    public void setDur_dn(int dur_dn) {
        this.dur_dn = dur_dn;
    }

    public int getDur_dn_data2() {
        return dur_dn_data2;
    }

    public void setDur_dn_data2(int dur_dn_data2) {
        this.dur_dn_data2 = dur_dn_data2;
    }

    public int getDur_dn_data4() {
        return dur_dn_data4;
    }

    public void setDur_dn_data4(int dur_dn_data4) {
        this.dur_dn_data4 = dur_dn_data4;
    }

    public int getDur_id_data2() {
        return dur_id_data2;
    }

    public void setDur_id_data2(int dur_id_data2) {
        this.dur_id_data2 = dur_id_data2;
    }

    public int getDur_id_data4() {
        return dur_id_data4;
    }

    public void setDur_id_data4(int dur_id_data4) {
        this.dur_id_data4 = dur_id_data4;
    }

    public int getDur_id_decrypt() {
        return dur_id_decrypt;
    }

    public void setDur_id_decrypt(int dur_id_decrypt) {
        this.dur_id_decrypt = dur_id_decrypt;
    }

    public int getDur_log_nd() {
        return dur_log_nd;
    }

    public void setDur_log_nd(int dur_log_nd) {
        this.dur_log_nd = dur_log_nd;
    }

    public int getDur_log_yx() {
        return dur_log_yx;
    }

    public void setDur_log_yx(int dur_log_yx) {
        this.dur_log_yx = dur_log_yx;
    }

    public int getDur_mode_check() {
        return dur_mode_check;
    }

    public void setDur_mode_check(int dur_mode_check) {
        this.dur_mode_check = dur_mode_check;
    }

    public int getDur_mode_count() {
        return dur_mode_count;
    }

    public void setDur_mode_count(int dur_mode_count) {
        this.dur_mode_count = dur_mode_count;
    }

    public int getDur_parallel_auth() {
        return dur_parallel_auth;
    }

    public void setDur_parallel_auth(int dur_parallel_auth) {
        this.dur_parallel_auth = dur_parallel_auth;
    }

    public int getDur_pic() {
        return dur_pic;
    }

    public void setDur_pic(int dur_pic) {
        this.dur_pic = dur_pic;
    }

    public int getDur_pic_data2() {
        return dur_pic_data2;
    }

    public void setDur_pic_data2(int dur_pic_data2) {
        this.dur_pic_data2 = dur_pic_data2;
    }

    public int getDur_pic_data4() {
        return dur_pic_data4;
    }

    public void setDur_pic_data4(int dur_pic_data4) {
        this.dur_pic_data4 = dur_pic_data4;
    }

    public int getDur_pic_decrypt() {
        return dur_pic_decrypt;
    }

    public void setDur_pic_decrypt(int dur_pic_decrypt) {
        this.dur_pic_decrypt = dur_pic_decrypt;
    }

    public int getDur_public_power() {
        return dur_public_power;
    }

    public void setDur_public_power(int dur_public_power) {
        this.dur_public_power = dur_public_power;
    }

    public int getDur_query_cache_mode() {
        return dur_query_cache_mode;
    }

    public void setDur_query_cache_mode(int dur_query_cache_mode) {
        this.dur_query_cache_mode = dur_query_cache_mode;
    }

    public int getDur_retain_decrypt() {
        return dur_retain_decrypt;
    }

    public void setDur_retain_decrypt(int dur_retain_decrypt) {
        this.dur_retain_decrypt = dur_retain_decrypt;
    }

    public int getDur_sign_verify() {
        return dur_sign_verify;
    }

    public void setDur_sign_verify(int dur_sign_verify) {
        this.dur_sign_verify = dur_sign_verify;
    }

    public int getDur_total() {
        return dur_total;
    }

    public void setDur_total(int dur_total) {
        this.dur_total = dur_total;
    }

    public int getDur_voucher() {
        return dur_voucher;
    }

    public void setDur_voucher(int dur_voucher) {
        this.dur_voucher = dur_voucher;
    }

    public int getDur_voucher_data4() {
        return dur_voucher_data4;
    }

    public void setDur_voucher_data4(int dur_voucher_data4) {
        this.dur_voucher_data4 = dur_voucher_data4;
    }
}
