package com.yingxin.prms.domain;

import org.springframework.data.cassandra.core.cql.PrimaryKeyType;
import org.springframework.data.cassandra.core.mapping.PrimaryKeyColumn;
import org.springframework.data.cassandra.core.mapping.Table;

@Table("server_host_info")
public class Server_Host_Info {

    @PrimaryKeyColumn(type = PrimaryKeyType.PARTITIONED)
    private String service_method;

    @PrimaryKeyColumn
    private String cluster_name;

    @PrimaryKeyColumn
    private String host_name;

    @PrimaryKeyColumn
    private String service_path;

    private String host_ip;

    private short host_port;

    private String request_body;

    private String response_body;

    private String service_password;

    private String layer;

    public Server_Host_Info(String service_method, String cluster_name, String host_name,
                            String service_path, String host_ip, short host_port, String request_body,
                            String response_body, String service_password,String layer) {
        this.service_method = service_method;
        this.cluster_name = cluster_name;
        this.host_name = host_name;
        this.service_path = service_path;
        this.host_ip = host_ip;
        this.host_port = host_port;
        this.request_body = request_body;
        this.response_body = response_body;
        this.service_password = service_password;
        this.layer = layer;
    }

    @Override
    public String toString() {
        return "Server_Host_Info{" +
                "service_method='" + service_method + '\'' +
                ", cluster_name='" + cluster_name + '\'' +
                ", host_name='" + host_name + '\'' +
                ", service_path='" + service_path + '\'' +
                ", host_ip='" + host_ip + '\'' +
                ", host_port=" + host_port +
                ", request_body='" + request_body + '\'' +
                ", response_body='" + response_body + '\'' +
                ", service_password='" + service_password + '\'' +
                ", layer='" + layer + '\'' +
                '}';
    }

    public String getService_method() {
        return service_method;
    }

    public void setService_method(String service_method) {
        this.service_method = service_method;
    }

    public String getCluster_name() {
        return cluster_name;
    }

    public void setCluster_name(String cluster_name) {
        this.cluster_name = cluster_name;
    }

    public String getHost_name() {
        return host_name;
    }

    public void setHost_name(String host_name) {
        this.host_name = host_name;
    }

    public String getService_path() {
        return service_path;
    }

    public void setService_path(String service_path) {
        this.service_path = service_path;
    }

    public short getHost_port() {
        return host_port;
    }

    public void setHost_port(short host_port) {
        this.host_port = host_port;
    }

    public String getRequest_body() {
        return request_body;
    }

    public void setRequest_body(String request_body) {
        this.request_body = request_body;
    }

    public String getResponse_body() {
        return response_body;
    }

    public void setResponse_body(String response_body) {
        this.response_body = response_body;
    }

    public String getHost_ip() {
        return host_ip;
    }

    public void setHost_ip(String host_ip) {
        this.host_ip = host_ip;
    }

    public String getService_password() {
        return service_password;
    }

    public void setService_password(String service_password) {
        this.service_password = service_password;
    }

    public String getLayer() {
        return layer;
    }

    public void setLayer(String layer) {
        this.layer = layer;
    }
}
