package com.yingxin.prms.domain;

import org.springframework.data.cassandra.core.cql.Ordering;
import org.springframework.data.cassandra.core.cql.PrimaryKeyType;
import org.springframework.data.cassandra.core.mapping.PrimaryKeyColumn;
import org.springframework.data.cassandra.core.mapping.Table;

import java.io.Serializable;
import java.util.Date;

@Table(value = "ctid_request_perf")
public class CTID_Request_Perf implements Serializable {

    @PrimaryKeyColumn(ordinal = 3, type = PrimaryKeyType.CLUSTERED, ordering = Ordering.DESCENDING)
    private String bsn;

    private String auth_mode;

    private Integer dur_acl_check;

    private Integer dur_bizpackage_sign;

    private Integer dur_gen_bsn;

    private Integer dur_log_nd;

    private Integer dur_log_yx;

    private Integer dur_random_sign;

    private Integer dur_sign_verify;

    private Integer dur_token;

    private Integer dur_total;

    @PrimaryKeyColumn(ordinal = 0, type = PrimaryKeyType.PARTITIONED)
    private String ip;

    @PrimaryKeyColumn(ordinal = 1, type = PrimaryKeyType.CLUSTERED, ordering = Ordering.DESCENDING)
    private Integer port;

    @PrimaryKeyColumn(ordinal = 2, type = PrimaryKeyType.CLUSTERED, ordering = Ordering.DESCENDING)
    private Date stamp;

    private String userid;

    public CTID_Request_Perf(String bsn, String auth_mode, Integer dur_acl_check, Integer dur_bizpackage_sign, Integer dur_gen_bsn, Integer dur_log_nd, Integer dur_log_yx, Integer dur_random_sign, Integer dur_sign_verify, Integer dur_token, Integer dur_total, String ip, Integer port, Date stamp, String userid) {
        this.bsn = bsn;
        this.auth_mode = auth_mode;
        this.dur_acl_check = dur_acl_check;
        this.dur_bizpackage_sign = dur_bizpackage_sign;
        this.dur_gen_bsn = dur_gen_bsn;
        this.dur_log_nd = dur_log_nd;
        this.dur_log_yx = dur_log_yx;
        this.dur_random_sign = dur_random_sign;
        this.dur_sign_verify = dur_sign_verify;
        this.dur_token = dur_token;
        this.dur_total = dur_total;
        this.ip = ip;
        this.port = port;
        this.stamp = stamp;
        this.userid = userid;
    }

    @Override
    public String toString() {
        return "CTID_Request_Perf{" +
                "bsn='" + bsn + '\'' +
                ", auth_mode='" + auth_mode + '\'' +
                ", dur_acl_check=" + dur_acl_check +
                ", dur_bizpackage_sign=" + dur_bizpackage_sign +
                ", dur_gen_bsn=" + dur_gen_bsn +
                ", dur_log_nd=" + dur_log_nd +
                ", dur_log_yx=" + dur_log_yx +
                ", dur_random_sign=" + dur_random_sign +
                ", dur_sign_verify=" + dur_sign_verify +
                ", dur_token=" + dur_token +
                ", dur_total=" + dur_total +
                ", ip='" + ip + '\'' +
                ", port=" + port +
                ", stamp=" + stamp +
                ", userid='" + userid + '\'' +
                '}';
    }

    public String getBsn() {
        return bsn;
    }

    public void setBsn(String bsn) {
        this.bsn = bsn;
    }

    public String getAuth_mode() {
        return auth_mode;
    }

    public void setAuth_mode(String auth_mode) {
        this.auth_mode = auth_mode;
    }

    public Integer getDur_acl_check() {
        return dur_acl_check;
    }

    public void setDur_acl_check(Integer dur_acl_check) {
        this.dur_acl_check = dur_acl_check;
    }

    public Integer getDur_bizpackage_sign() {
        return dur_bizpackage_sign;
    }

    public void setDur_bizpackage_sign(Integer dur_bizpackage_sign) {
        this.dur_bizpackage_sign = dur_bizpackage_sign;
    }

    public Integer getDur_gen_bsn() {
        return dur_gen_bsn;
    }

    public void setDur_gen_bsn(Integer dur_gen_bsn) {
        this.dur_gen_bsn = dur_gen_bsn;
    }

    public Integer getDur_log_nd() {
        return dur_log_nd;
    }

    public void setDur_log_nd(Integer dur_log_nd) {
        this.dur_log_nd = dur_log_nd;
    }

    public Integer getDur_log_yx() {
        return dur_log_yx;
    }

    public void setDur_log_yx(Integer dur_log_yx) {
        this.dur_log_yx = dur_log_yx;
    }

    public Integer getDur_random_sign() {
        return dur_random_sign;
    }

    public void setDur_random_sign(Integer dur_random_sign) {
        this.dur_random_sign = dur_random_sign;
    }

    public Integer getDur_sign_verify() {
        return dur_sign_verify;
    }

    public void setDur_sign_verify(Integer dur_sign_verify) {
        this.dur_sign_verify = dur_sign_verify;
    }

    public Integer getDur_token() {
        return dur_token;
    }

    public void setDur_token(Integer dur_token) {
        this.dur_token = dur_token;
    }

    public Integer getDur_total() {
        return dur_total;
    }

    public void setDur_total(Integer dur_total) {
        this.dur_total = dur_total;
    }

    public String getIp() {
        return ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public Integer getPort() {
        return port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public Date getStamp() {
        return stamp;
    }

    public void setStamp(Date stamp) {
        this.stamp = stamp;
    }

    public String getUserid() {
        return userid;
    }

    public void setUserid(String userid) {
        this.userid = userid;
    }
}
