package com.yingxin.prms.config;

import org.springframework.context.annotation.Configuration;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.http.SessionCreationPolicy;

@Configuration
@EnableWebSecurity
public class SecurityConfig extends WebSecurityConfigurerAdapter {

    @Override
    protected void configure(HttpSecurity http) throws Exception {
        http.cors().and().csrf().disable()
                .sessionManagement().sessionCreationPolicy(SessionCreationPolicy.NEVER)
                .and().authorizeRequests()
                .antMatchers("/rest/scy/login").permitAll()
//                .antMatchers("/rest/perf/*").authenticated()
//                .antMatchers("/rest/rel/*").authenticated()
                .antMatchers("/rest/perf/*").permitAll()
                .antMatchers("/rest/rel/*").permitAll();
//                .and()
//                .addFilterBefore(new JwtLoginFilter("/rest/scy/login", authenticationManager()), UsernamePasswordAuthenticationFilter.class)
//                .addFilter(new JwtAuthenticationFilter(authenticationManager()));
    }

}
