package com.yingxin.prms.config;

import org.apache.http.impl.client.HttpClientBuilder;
import org.kairosdb.client.HttpClient;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import java.net.MalformedURLException;

@Configuration
public class InitPoolingKairosClientConfig {

    @Value("${demo.kairosdb.url}")
    private String KAIROSDB_URL;

    @Value("${demo.kairosdb.maxConnTotal}")
    private int MAX_CONN_TOTAL;

    @Value("${demo.kairosdb.maxConnPerRoute}")
    private int MAX_CONN_PER_ROUTE;

    @Bean
    public HttpClient httpClient() {
        HttpClientBuilder builder = HttpClientBuilder.create();
        builder.setMaxConnTotal(MAX_CONN_TOTAL);
        builder.setMaxConnPerRoute(MAX_CONN_PER_ROUTE);
        try {
            return new HttpClient(builder, KAIROSDB_URL);
        } catch (MalformedURLException e) {
            e.printStackTrace();
        }
        return null;
    }
}
