package com.yingxin.prms.utils;

import org.apache.http.HttpEntity;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.kairosdb.client.builder.QueryBuilder;
import org.springframework.http.ResponseEntity;

import javax.xml.crypto.Data;
import java.io.IOException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

/**
 * Created by GavinLi on 2017/12/21.
 */
public class TimeUtil {
    public static Long getTimeStamp(int unit,long value,long endstamp){
        long StartTimeStamp = 0L;
        switch(unit){
            case 1:StartTimeStamp = endstamp - value*60*1000;break;
            case 2:StartTimeStamp = endstamp - value*1000;break;
        }
        return StartTimeStamp;
    }

    public static String strToDateFormat(String date) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMdd");
        formatter.setLenient(false);
        Date newDate;
        try {
            newDate = formatter.parse(date);
        } catch (ParseException e) {
            e.printStackTrace();
            newDate = new Date();
        }
        formatter = new SimpleDateFormat("yyyy-MM-dd");
        return formatter.format(newDate);
    }

    public static String getDate(){
        Date  date = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return sdf.format(date);
    }

    public static String getDateToTimeStamp(String dataStr) {
        Date date = null;
        try {
            date = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(dataStr);
        } catch (ParseException e) {
            e.printStackTrace();
        }
        return date.getTime()+"";
    }


    public static String getDate2(){
        Date  date = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        return sdf.format(date);
    }

    public static String getMD5Result(String password){
        return password.substring(12,password.length()-24);
    }


    public static String toDate(long time){
        Date date = new Date(time);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return sdf.format(date);
    }

    public static Date PreviousDay(Date date){
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(Calendar.DAY_OF_MONTH,
                calendar.get(Calendar.DAY_OF_MONTH) - 1);// 让日期减1
        return calendar.getTime();
    }

    public static String getTimeStampString() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        Calendar beforeTime = Calendar.getInstance();
        Date beforeD = beforeTime.getTime();
        String time = sdf.format(beforeD);
        return time;
    }


}
