package com.yingxin.prms.service.schedule;

import com.yingxin.prms.domain.Server_Host_Info;
import com.yingxin.prms.dto.AuthModeAndHostList;
import com.yingxin.prms.service.asyncTask.*;
import com.yingxin.prms.utils.TimeUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;

@Component
public class Schedule {

    private final HttpTask httpTask;

    private final UdpTask udpTask;

    private final RedisTask redisTask;

    private final AlarmTask alarmTask;

    private final AuthModeAndHostList list;

    private final PortraitCheckTimeTask portraitCheckTimeTask;

    private final AuthSuccessRateTask authSuccessRateTask;

    private final LogSystemAlarmTask logSystemAlarmTask;

    private static Logger logger = LoggerFactory.getLogger(Schedule.class);

    @Autowired
    public Schedule(AuthModeAndHostList list, HttpTask httpTask, UdpTask udpTask, RedisTask redisTask, AlarmTask alarmTask, PortraitCheckTimeTask portraitCheckTimeTask, AuthSuccessRateTask authSuccessRateTask, LogSystemAlarmTask logSystemAlarmTask) {
        this.list = list;
        this.httpTask = httpTask;
        this.udpTask = udpTask;
        this.redisTask = redisTask;
        this.alarmTask = alarmTask;
        this.portraitCheckTimeTask = portraitCheckTimeTask;
        this.authSuccessRateTask = authSuccessRateTask;
        this.logSystemAlarmTask = logSystemAlarmTask;
    }

    @Scheduled(initialDelay = 5000, fixedDelay = 10000)
    public void inspect() {
        logger.info("开始探测任务");
        ConcurrentHashMap<String, String> alarmHost = list.getAlarmHost();
        List<Server_Host_Info> server_host_infos = list.getClusterBeMonitoredList();
        for (Server_Host_Info hostInfo : server_host_infos) {
            if (hostInfo.getService_method().equals("post")) httpTask.doTask(hostInfo, alarmHost);
            if (hostInfo.getService_method().equals("get")) httpTask.doTask(hostInfo, alarmHost);
            if (hostInfo.getService_method().equals("udp")) udpTask.doTask(hostInfo, alarmHost);
            if (hostInfo.getService_method().equals("redis")) redisTask.doTask(hostInfo, alarmHost);
        }
    }

    @Scheduled(initialDelay = 60000, fixedDelay = 20000)
    public void alarm() {
        logger.info("开始告警判断");
        List<Server_Host_Info> server_host_infos = list.getClusterBeMonitoredList();
        for (Server_Host_Info hostInfo : server_host_infos) {
            alarmTask.doTask(hostInfo);
        }
    }

    @Scheduled(initialDelay = 10000, fixedDelay = 60000)
    public void authModeConsum() {
        logger.info("获取平台认证耗时");
        List<String> modes = new ArrayList<>();
        modes.add("YTCR-BASIC");
        modes.add("YRDTYTCR-BASIC");
        String begin = TimeUtil.getTimeStampString();
        for (int i = 0; i < modes.size(); i++) {
            portraitCheckTimeTask.doTask(modes, begin, "0", "1");
        }
    }

    @Scheduled(initialDelay = 10000, fixedDelay = 60000)
    public void authSuccessRate() {
        logger.info("获取平台认证对比率");
        List<String> modes = new ArrayList<>();
        modes.add("YTCR-BASIC");
        modes.add("YRDTYTCR-BASIC");
        long end = System.currentTimeMillis();
        String begin = end - 60000 + "";
        authSuccessRateTask.doTask(modes, begin, "", "");
    }

    /**
     * 日志统计中异常百分比超过%，就行告警表中添加一天告警数据
     * 通知日志统计异常率超过%
     */
    @Scheduled(initialDelay = 10000, fixedDelay = 60000)
    public void setLogSystemAlarmTask() {
        logger.info("判断日志统计中异常百分比");
        System.currentTimeMillis();
        logSystemAlarmTask.doTask("",System.currentTimeMillis()-120000,System.currentTimeMillis()-60000);
    }
}
