package com.yingxin.prms.service.dao;

import com.yingxin.prms.config.Constant;
import com.yingxin.prms.domain.*;
import com.yingxin.prms.utils.TimeUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.cassandra.core.CassandraTemplate;
import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.Map;


@Repository
public class CassandraDaoImpl {

    private final CassandraTemplate template;

    @Autowired
    public CassandraDaoImpl(CassandraTemplate template) {
        this.template = template;
    }


    public List<Auth_Mode_Dic> getAuthModeList() {
        return template.select("select * from ctid_prof.auth_mode_dic;", Auth_Mode_Dic.class);
    }

    public List<CTID_Request_Host_Dic> getRequestHostList() {
        return template.select("select * from ctid_prof.ctid_request_host_dic;", CTID_Request_Host_Dic.class);
    }

    public List<CTID_Process_Host_Dic> getProcessHostList() {
        return template.select("select * from ctid_prof.ctid_process_host_dic;", CTID_Process_Host_Dic.class);
    }

    public List<Server_Host_Info> getClusterBeMonitoredList() {
        return template.select("select * from ctid_prof.server_host_info;", Server_Host_Info.class);
    }

    //插入server_host_info信息
    public int insertServerHostInfo(Server_Host_Info server_host_info) {
        template.insert(server_host_info);
        return 1;
    }
    //删除server_host_info信息
    public int delServerHostInfo(Server_Host_Info server_host_info) {
        template.delete(server_host_info);
        return 1;
    }
    //修改server_host_info信息
    public int updateServerHostInfo(Server_Host_Info server_host_info) {
        template.update(server_host_info);
        return 1;
    }

    public void saveReqBLV(CTID_Request_Perf_BaseLineValue entity) {
        template.insert(entity);
    }

    public void saveProBLV(CTID_Process_Perf_BaseLineValue entity) {
        template.insert(entity);
    }

//    public List<CTID_Request_Perf_BaseLineValue> getReqBLV() {
//        return template.select("select * from ctid_prof.ctid_request_perf_base_line_value;", CTID_Request_Perf_BaseLineValue.class);
//    }
//
//    public List<CTID_Process_Perf_BaseLineValue> getProBLV() {
//        return template.select("select * from ctid_prof.ctid_process_perf_base_line_value;", CTID_Process_Perf_BaseLineValue.class);
//    }

    public List<AlarmLog> getAlarmLog(int size,long flag) {
        String cql="select * from ctid_prof.alarm_log where state = '"+Constant.ALARM_RECOVERY+"' and serialnum < "+flag+"  order by alatime desc limit "+size+ " allow filtering;";
        return template.select(cql, AlarmLog.class);
    }

    public List<AlarmLog> getAlarmLog(int size) {
        String cql="select * from ctid_prof.alarm_log where state = '"+Constant.ALARM_RECOVERY+"' order by alatime desc limit "+size+ " allow filtering;";
        return template.select(cql, AlarmLog.class);
    }

    public List<AlarmLog> getAlarmLogALARM_ING(int size,long flag) {
        String cql="select * from ctid_prof.alarm_log where state = '"+Constant.ALARM_ING+"' and serialnum<"+flag+"  order by alatime desc limit "+size+ " allow filtering;";
        return template.select(cql, AlarmLog.class);
    }

    public List<AlarmLog> getAlarmLogList() {
        String cql="select * from ctid_prof.alarm_log where state = '" +Constant.ALARM_RECOVERY+"' order by alatime desc allow filtering";
        return template.select(cql, AlarmLog.class);
    }
    public List<AlarmMsg> getAlarmMsgList() {
        String cql="select * from ctid_prof.alarm_msg where state = '" +Constant.ALARM_ING+"' allow filtering";
        return template.select(cql, AlarmMsg.class);
    }

    public AlarmMsg checkAlarm(String name,String ip,String port) {
        String cql="select * from ctid_prof.alarm_msg where cluster_name = '"+name+"' and ip = '"+ip+"' and port = '"+port+"' and state = '" +Constant.ALARM_ING+"' allow filtering";
        return template.selectOne(cql, AlarmMsg.class);
    }
/*变更告警信息（已启用）*/
 /*   public boolean updateAlarm(String serialnum,String time) {
        String cql="update ctid_prof.alarm_log set rectime = '"+time+"' , state = '" +Constant.ALARM_RECOVERY +"', alarm_level = '"+Constant.ALARM_OK+"' where serialnum = '"+serialnum +"'";
        return template.getCqlOperations().execute(cql);
    }*/
    public void insertAlarmLog(AlarmMsg alarmMsg,String time) {
        String cql ="INSERT INTO ctid_prof.alarm_log (serialnum, alarm_level, alarm_message, alatime, cluster_name, ip, port, rectime, state)" +
                "VALUES("+alarmMsg.getSerialnum()+", '"+Constant.ALARM_OK+"', '"+alarmMsg.getAlarmMessage()+"', '"+TimeUtil.getDate()+"', '"+alarmMsg.getClusterName()+"', '"+alarmMsg.getIp()+"', '"+alarmMsg.getPort()+"', '"+time+"', '"+Constant.ALARM_RECOVERY+"');";
        template.getCqlOperations().execute(cql);
    }

    public void insertAlarmMsg(AlarmMsg alarmMsg) {
        String cql ="INSERT INTO ctid_prof.alarm_msg (serialnum, alarm_level, alarm_message, alatime, cluster_name, ip, port, state)" +
                "VALUES("+System.currentTimeMillis()+", '"+alarmMsg.getAlarmLevel()+"', '"+alarmMsg.getAlarmMessage()+"', '"+ TimeUtil.getDate()+"', '"+alarmMsg.getClusterName()+"', '"+alarmMsg.getIp()+"', '"+alarmMsg.getPort()+"', '"+Constant.ALARM_ING+"');";
        template.getCqlOperations().execute(cql);
    }
    public Map getAlarmLogSize() {
        String cql="select count(*) from ctid_prof.alarm_log where state < '" +Constant.ALARM_ING+"' allow filtering";
        return template.selectOne(cql,Map.class);
    }

    public void delAlarmMsg(AlarmMsg alarmMsg) {
        String cql ="DELETE FROM  ctid_prof.alarm_msg WHERE state='"+alarmMsg.getState()+"'  AND alatime='"+alarmMsg.getAlatime()+"' AND serialnum="+alarmMsg.getSerialnum()+" ;";
        template.getCqlOperations().execute(cql);
    }

    public Admin findByUsername(String username) {
        String cql = "SELECT *  FROM ctid_prof.admin where username = '"+username+"';";
        return template.selectOne(cql,Admin.class);
    }

    public Server_Host_Info findHostInfo(String url) {
        String cql ="select * from ctid_prof.server_host_info where service_path = '"+url+"' allow filtering;;";
        return template.selectOne(cql, Server_Host_Info.class);
    }

    public Server_Host_Info getStatisticsUri() {
        String cql = "select * from server_host_info where cluster_name = '平台业务实时统计服务' allow filtering";
        return template.selectOne(cql, Server_Host_Info.class);
    }

    public AlarmLog findAlarmBySernum(String serialnum) {
        String cql="SELECT * FROM ctid_prof.alarm_log where serialnum = '"+serialnum +"'";
        return template.selectOne(cql, AlarmLog.class);
    }

    public boolean changeSwitch(String state) {
        String cql ="UPDATE ctid_prof.alarm_switch SET switch='"+state+"'" +
                "WHERE  username='admin';";
        return template.getCqlOperations().execute(cql);
    }

    public Map getSwitch() {
        String cql ="SELECT * FROM ctid_prof.alarm_switch WHERE  username='admin';";
        return template.selectOne(cql,Map.class);
    }

    public List<AlarmLog> getAlarmLogList(String start, String end,int size,long flag) {
        String cql="select * from ctid_prof.alarm_log where alatime > '"+start+"' and alatime < '"+end+"'and state = '" +Constant.ALARM_RECOVERY+"' and serialnum<"+flag+"  order by alatime desc limit "+size+ " allow filtering";
        return template.select(cql, AlarmLog.class);
    }

    public List<AlarmLog> getAlarmLogList(String ip,int size,long flag) {
        String cql="select * from ctid_prof.alarm_log where ip like '%"+ip+"%' and state = '" +Constant.ALARM_RECOVERY+"' and serialnum<"+flag+"  limit "+size+ " allow filtering";
        return template.select(cql, AlarmLog.class);
    }

    public List<AlarmLog> getAlarmLogList(String ip, String start, String end,int size,long flag) {
        String cql="select * from ctid_prof.alarm_log where ip like '%"+ip+"%'  and alatime>'"+start+"' and alatime <'"+end+"' and state = '" +Constant.ALARM_RECOVERY+"' and serialnum<"+flag+" limit "+size+ " allow filtering";
        return template.select(cql, AlarmLog.class);
    }

    public Map getAlarmLogSize(String start, String end) {
        String cql="select count(*) from ctid_prof.alarm_log where alatime > '"+start+"' and alatime < '"+end+"' and state = '" +Constant.ALARM_RECOVERY+"' allow filtering";
        return template.selectOne(cql,Map.class);
    }
    //根据开始与结束时间
    public List<AlarmLog> getAlarmLogByStartAndEnd(String start, String end) {
        String cql="select * from ctid_prof.alarm_log where alatime > '"+start+"' and alatime < '"+end+"' and state = '" +Constant.ALARM_RECOVERY+"' allow filtering";
        return template.select(cql,AlarmLog.class);
    }

    public Map getAlarmLogSize(String ip) {
        String cql="select count(*) from ctid_prof.alarm_log where ip like '%"+ip+"%' and state = '" +Constant.ALARM_RECOVERY+"' allow filtering";
        return template.selectOne(cql,Map.class);
    }
    //根据ip地址查询告警日志
    public  List<AlarmLog>  getAlarmLogByIp(String ip) {
        String cql="select * from ctid_prof.alarm_log where ip like '%"+ip+"%' and state = '" +Constant.ALARM_RECOVERY+"' allow filtering";
        return template.select(cql,AlarmLog.class);
    }

    public Map getAlarmLogSize(String ip, String start, String end) {
        String cql="select count(*) from ctid_prof.alarm_log where ip like '%"+ip+"%' and alatime > '"+start+"' and alatime <'"+end+"' and state = '" +Constant.ALARM_RECOVERY+"' allow filtering";
        return template.selectOne(cql,Map.class);
    }

    public List<AlarmLog> getAlarmLogByParam(String ip, String start, String end) {
        String cql="select * from ctid_prof.alarm_log where ip like '%"+ip+"%' and alatime > '"+start+"' and alatime <'"+end+"' and state = '" +Constant.ALARM_RECOVERY+"' allow filtering";
        return template.select(cql,AlarmLog.class);
    }

}
