package com.yingxin.prms.service.dao;

import com.yingxin.prms.domain.Auth_Mode_Avg;
import com.yingxin.prms.domain.Auth_Success_Rate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.cassandra.core.CassandraTemplate;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * @Author by shao
 * @Create 2023/3/2 11:42
 */
@Repository
public class AuthSuccessRateImpl {
    private final CassandraTemplate template;
    @Autowired
    public AuthSuccessRateImpl(CassandraTemplate template) {
        this.template = template;
    }

    public void save(Auth_Success_Rate authSuccessRate){
        template.insert(authSuccessRate);
    }

    public List<Auth_Success_Rate> findAllByMode(String mode){
        return template.select("select * from ctid_prof.auth_success_rate where mode = '"+mode+"';",Auth_Success_Rate.class);
    }

    public List<Auth_Success_Rate> findLineChartTSuccessData(String mode){
        return template.select("select * from ctid_prof.auth_success_rate where mode = '"+mode+"' order by timestamp desc limit 20;",Auth_Success_Rate.class);
    }

    public List<Auth_Success_Rate> findLineChartTSuccessLim1(String mode){
        return template.select("select * from ctid_prof.auth_success_rate where mode = '"+mode+"' order by timestamp desc limit 1;",Auth_Success_Rate.class);
    }
}
