package com.yingxin.prms.service.dao;

import com.yingxin.prms.domain.Auth_Mode_Avg;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.cassandra.core.CassandraTemplate;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * @Author by shao
 * @Create 2023/3/2 11:42
 */
@Repository
public class AuthModeAvgImpl {
    private final CassandraTemplate template;
    @Autowired
    public AuthModeAvgImpl(CassandraTemplate template) {
        this.template = template;
    }

    public void save(Auth_Mode_Avg authModeAvg){
        template.insert(authModeAvg);
    }

    public List<Auth_Mode_Avg> findAllByMode(String mode){
        return template.select("select * from ctid_prof.auth_mode_avg where mode = '"+mode+"';",Auth_Mode_Avg.class);
    }

    public List<Auth_Mode_Avg> findLineChartTimeData(String mode){
        return template.select("select * from ctid_prof.auth_mode_avg where mode = '"+mode+"' order by timestamp desc limit 20;",Auth_Mode_Avg.class);
    }

    public List<Auth_Mode_Avg> findLineChartTimelim1(String mode){
        return template.select("select * from ctid_prof.auth_mode_avg where mode = '"+mode+"' order by timestamp desc limit 1;",Auth_Mode_Avg.class);
    }

}
