package com.yingxin.prms.service.business;

import com.yingxin.prms.config.ServiceNameConfig;
import com.yingxin.prms.config.ServiceRelationConfig;
import com.yingxin.prms.config.filter.TokenInterceptor;
import com.yingxin.prms.domain.*;
import com.yingxin.prms.dto.*;
import com.yingxin.prms.dto.wx.MonitorConfig;
import com.yingxin.prms.service.asyncTask.QueryHostStatusTask;
import com.yingxin.prms.service.dao.CassandraDaoImpl;
import com.yingxin.prms.service.dao.FlowDaoImpl;
import com.yingxin.prms.utils.*;
import net.sf.json.JSON;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.catalina.Server;
import org.kairosdb.client.HttpClient;
import org.kairosdb.client.builder.*;
import org.kairosdb.client.response.QueryResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

import javax.xml.stream.events.StartDocument;
import java.io.IOException;
import java.util.*;
import java.util.concurrent.*;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;


@Service
public class Manager {

    @Autowired
    ServiceNameConfig serviceNameConfig;
    @Autowired
    ServiceRelationConfig srConfig;

    @Value("${ascynTaskThreadPool.clusterStatusPoolSize}")
    private int THREADPOOLSIZE;

    @Value("${tokeTime}")
    private long tokeTime;

    @Value("${pointNumber}")
    private int pointNumber;

    /*企业ID*/
    @Value("${corpid}")
    public String corpid;

    /*管理组凭证密钥*/
    @Value("${corpsecret}")
    public String corpsecret;

    /*应用代理ID*/
    @Value("${agentId}")
    public String agentId;

    /*wx告警地址*/
    @Value("${wxurl}")
    public String wxurl;

    private final AuthModeAndHostList authModeAndHostList;

    private final CassandraDaoImpl cassandraDao;

    private static CassandraDaoImpl cassandraDaoStatic;

    @Autowired
    private FlowDaoImpl flowDao;

    private RestTemplate restTemplate;

    private final HttpClient httpClient;

    @Autowired
    private TokenInterceptor tokenInterceptor;


    @Autowired
    public Manager(AuthModeAndHostList authModeAndHostList, CassandraDaoImpl cassandraDao, HttpClient httpClient) {
        restTemplate = new RestTemplate();
        this.authModeAndHostList = authModeAndHostList;
        this.cassandraDao = cassandraDao;
        this.httpClient = httpClient;
    }


    /**
     * 获取二包的服务器ip和port
     *
     * @return 服务器ip和port列表
     */
    public List selectSecondIpAndPort() {
        List<Map> hostInfos = new ArrayList<>();
        for (CTID_Process_Host_Dic processHost : authModeAndHostList.getProcessHostList()) {
            HashMap<String, Object> hostInfo = new HashMap<>();
            hostInfo.put("ip", processHost.getIp());
            hostInfo.put("port", processHost.getPort());
            hostInfos.add(hostInfo);
        }
        return hostInfos;

    }

    public Map<String, Object> getAlarmLog(String json) {
        Map<String,Object> map = new HashMap();
        JSONObject jsonObject  = JSONObject.fromObject(json);
        int pageNum = jsonObject.getInt("pageNum");
        int pageSize = jsonObject.getInt("pageSize");

        int i = 0;
        long flag = System.currentTimeMillis();
        Map total = cassandraDao.getAlarmLogSize();
        List<AlarmLog> logList = null;
        do{
            logList = cassandraDao.getAlarmLog(pageSize,flag);
            if (logList.size()==0){
                break;
            }
            AlarmLog alarmLog = logList.get(logList.size()-1);
            flag = alarmLog.getSerialnum();
            i++;
        }while(i<pageNum);

        map.put("log",logList);
        map.put("logSize",total.get("count"));
        return map;
    }

    public Map<String, Object> getAlarmMsg() {
        Map<String,Object> map = new HashMap();
        List<AlarmMsg> alarmList = cassandraDao.getAlarmMsgList();
        if(alarmList != null && alarmList.size()>0){
            //查询结果非空List升序排序（根据AlarmMsg::getAlatime）
            alarmList = alarmList.stream().sorted(Comparator.comparing(AlarmMsg::getAlatime)).collect(Collectors.toList());
            //反转list排序
            Collections.reverse(alarmList);
        }
        map.put("alarmMsg",alarmList);
        return map;
    }
    public Map selectClusterStatus() {
        /*查询集群监控列表*/
        List<Server_Host_Info> host_info_List = authModeAndHostList.getClusterBeMonitoredList();
        List<SingleHostStatus> accessList = new ArrayList<>();
        List<SingleHostStatus> dataList = new ArrayList<>();
        List<SingleHostStatus> passportList = new ArrayList<>();
        List<SingleHostStatus> coreList = new ArrayList<>();

        List<Future> accessFuture = new ArrayList<>();
        List<Future> dataFuture = new ArrayList<>();
        List<Future> passportFuture = new ArrayList<>();
        List<Future> futureList = new ArrayList<>();
        List<Future> coreFuture = new ArrayList<>();
        List<SingleHostStatus> hostStatusList = new ArrayList<>();
        /*线程池*/
        ExecutorService service = Executors.newFixedThreadPool(THREADPOOLSIZE);

        for (Server_Host_Info hostInfo : host_info_List) {
            Future<SingleHostStatus> result = service.submit(new QueryHostStatusTask(hostInfo, httpClient));
            futureList.add(result);
            if (hostInfo.getLayer().equals("接入区")){
                accessFuture.add(result);
            }else if(hostInfo.getLayer().equals("算法区")){
                dataFuture.add(result);
            }else if(hostInfo.getLayer().equals("护照柜")){
                passportFuture.add(result);
            }else if(hostInfo.getLayer().equals("核心业务区")){
                coreFuture.add(result);
            }
        }
        service.shutdown();
        try {
            if (service.awaitTermination(3, TimeUnit.MINUTES)) {
                for (Future future : futureList) {
                    SingleHostStatus singleHostStatus = (SingleHostStatus) future.get();
                    hostStatusList.add(singleHostStatus);
                }
                for (Future future : accessFuture) {
                    SingleHostStatus singleHostStatus = (SingleHostStatus) future.get();
                    accessList.add(singleHostStatus);
                }
                for (Future future : dataFuture) {
                    SingleHostStatus singleHostStatus = (SingleHostStatus) future.get();
                    dataList.add(singleHostStatus);
                }
                for (Future future : passportFuture) {
                    SingleHostStatus singleHostStatus = (SingleHostStatus) future.get();
                    passportList.add(singleHostStatus);
                }
                for (Future future : coreFuture) {
                    SingleHostStatus singleHostStatus = (SingleHostStatus) future.get();
                    coreList.add(singleHostStatus);
                }
            }
        } catch (InterruptedException | ExecutionException e) {
            e.printStackTrace();
        }

        Map accessMap = selectClusterStatusBylayer(accessList);
        Map dataMap = selectClusterStatusBylayer(dataList);
        Map passportMap = selectClusterStatusBylayer(passportList);
        Map coreMap = selectClusterStatusBylayer(coreList);
        Map map  = new HashMap();
        map.put("接入区",accessMap);
        map.put("算法区",dataMap);
        map.put("护照柜",passportMap);
        map.put("核心业务区",coreMap);
        return map;
    }
    public Map selectClusterStatusBylayer(List<SingleHostStatus> hostStatusList){
        if (hostStatusList.size() != 0) {
            Map<String, Object> clusterStatus = new HashMap<>();
            Map<String, List<SingleHostStatus>> listMap = hostStatusList.stream().collect(Collectors.groupingBy(SingleHostStatus::getClusterName));
            for (Map.Entry<String, List<SingleHostStatus>> singleClusterStatusEntry : listMap.entrySet()) {
                String clusterName = singleClusterStatusEntry.getKey();
                Map<String, Object> singleClusterStatus = new HashMap<>();
                List<SingleHostStatus> singleHostStatusList = singleClusterStatusEntry.getValue();
                for (SingleHostStatus singleHostStatus : singleHostStatusList) {
                    singleClusterStatus.put(singleHostStatus.getHostName(), singleHostStatus.getHostStatus());
                }
                clusterStatus.put(clusterName, singleClusterStatus);
            }
            return clusterStatus;
        }
        return null;
    }

    public Map login(String json) {
        Map<String,Object>resultMap=new HashMap<>();
        JSONObject jsonObject  = JSONObject.fromObject(json);
        String username = jsonObject.getString("username");
        String password = jsonObject.getString("password");
        Map<String, String> tokenList = tokenInterceptor.getTokenList();
        Admin admin = cassandraDao.findByUsername(username);
        String passwordNew = TimeUtil.getMD5Result(password);
        if(admin!=null && admin.getPassword().equals(passwordNew)) {
            String token = TokenUtil.sign(tokeTime);
            resultMap.put("flag", true);
            resultMap.put("token", token);
            long time = (long) (tokeTime * 0.8);
            if(time>0){
                resultMap.put("time", time);
            }else{
                resultMap.put("time", tokeTime);
            }
            tokenList.put(username,token);
        }else{
            resultMap.put("flag", false);
        }
        return resultMap;

    }

    public Map<String, Object> getToken(String json) {
        Map<String, String> tokenList = tokenInterceptor.getTokenList();
        JSONObject jsonObject = JSONObject.fromObject(json);
        String username = jsonObject.getString("username");
        Map<String,Object>resultMap=new HashMap<>();
        String token = TokenUtil.sign(tokeTime);
        resultMap.put("token",token);
        tokenList.put(username,token);
        return resultMap;
    }

    public Map selectChart(String json) throws Exception{
        JSONObject jsonObject  = JSONObject.fromObject(json);
        String url = jsonObject.getString("url");
        String flag = jsonObject.getString("flag");

        Server_Host_Info hostInfo = cassandraDao.findHostInfo(url);
        return getData(hostInfo.getService_path(),flag);
    }

    private Map getData(String servicePath,String flag) throws Exception {


        /* 获取前六天数据 datapoints 具体时间段 数据 */
        List<DataPoint> dataPoints = getAgodataPoints(servicePath,flag);
        /* 获取今天数据 */
        List<DataPoint> currDataPoint = getdataPoints(servicePath,flag);

        /* 获取当前需要展示的横坐标 */
        double[] xFlag = null;
        String[] xResult = null;
        double[] yResult = null;
        double[] yForecast = null;
        if(currDataPoint.size() > 0 ){
            xFlag = new double[currDataPoint.size()];
            xResult=new String[currDataPoint.size()];
            yResult = new double[currDataPoint.size()];
            yForecast = new double[currDataPoint.size()];
            for (int i=0;i<currDataPoint.size();++i){
                xFlag[i] = currDataPoint.get(i).getTimestamp();
                xResult[i]= TimeUtil.toDate(currDataPoint.get(i).getTimestamp());
                yResult[i] = (int)Double.parseDouble(String.valueOf(currDataPoint.get(i).getValue()));
                yForecast[i] = 0;
            }
        }
        Map map = new HashMap();
        if(dataPoints.size()>1){
            double [] x=new double[dataPoints.size()];
            double [] y=new double[dataPoints.size()];
            for (int i=0;i<dataPoints.size();i++){
                x[i]= dataPoints.get(i).getTimestamp();
            }
            for (int i=0;i<dataPoints.size();i++){
                y[i]=Double.parseDouble(String.valueOf(dataPoints.get(i).getValue()) );
            }
            //阶数为4，固定值
            Map mapForecast = CurveFittingMethod.run(x, y,4,xFlag);
            //横坐标
            map.put("abscissa",xResult);
            //纵坐标
            map.put("ordinate",yResult);
            //纵坐标预测值
            map.put("ordinateForecast",mapForecast.get("y_data_array"));
        }else{
            map.put("abscissa",xResult);
            map.put("ordinate",yResult);
            map.put("ordinateForecast",yForecast);
        }
        return map;


    }

    private List<DataPoint> getdataPoints(String servicePath,String flag) throws Exception {
        QueryBuilder queryBuilder = QueryBuilder.getInstance();
        Calendar calendar = Calendar.getInstance();
        int number = pointNumber+ 1;
        switch (flag){
            case("one"):
                calendar.set(Calendar.MINUTE,
                        calendar.get(Calendar.MINUTE) - number);
                queryBuilder.setStart(calendar.getTime())
                        .setEnd(new Date())
                        .addMetric("respdur")
                        .addTag("host",servicePath)
                        .addAggregator(AggregatorFactory.createAverageAggregator(1, org.kairosdb.client.builder.TimeUnit.MINUTES));
                break;
            case("ten"):
                calendar.set(Calendar.MINUTE,
                        calendar.get(Calendar.MINUTE) - (number*10));
                queryBuilder.setStart(calendar.getTime())
                        .setEnd(new Date())
                        .addMetric("respdur")
                        .addTag("host",servicePath)
                        .addAggregator(AggregatorFactory.createAverageAggregator(10, org.kairosdb.client.builder.TimeUnit.MINUTES));

                break;
            case("thirty"):
                calendar.set(Calendar.MINUTE,
                        calendar.get(Calendar.MINUTE) - (number*30));
                queryBuilder.setStart(calendar.getTime())
                        .setEnd(new Date())
                        .addMetric("respdur")
                        .addTag("host",servicePath)
                        .addAggregator(AggregatorFactory.createAverageAggregator(30, org.kairosdb.client.builder.TimeUnit.MINUTES));
                break;
            case("hour"):
                calendar.set(Calendar.HOUR,
                        calendar.get(Calendar.HOUR) - number);
                queryBuilder.setStart(calendar.getTime())
                        .setEnd(new Date())
                        .addMetric("respdur")
                        .addTag("host",servicePath)
                        .addAggregator(AggregatorFactory.createAverageAggregator(1, org.kairosdb.client.builder.TimeUnit.HOURS));
                break;
        }
        QueryResponse response = httpClient.query(queryBuilder);
        return response.getQueries().get(0).getResults().get(0).getDataPoints();
    }


    private List<DataPoint> getAgodataPoints(String servicePath,String flag) throws IOException {
        QueryBuilder queryBuilder = QueryBuilder.getInstance() ;
        Date currDate = new Date();
        QueryResponse response = null;
        List<DataPoint> dataPoints  = new ArrayList<>();
        for(int i = 0 ;i<6 ;i++){
            currDate = TimeUtil.PreviousDay(currDate);
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(currDate);
            int number = pointNumber + 1;
            switch (flag){
                case("one"):
                    calendar.set(Calendar.MINUTE,
                            calendar.get(Calendar.MINUTE) - number);
                    queryBuilder.setStart(calendar.getTime())
                            .setEnd(currDate)
                            .addMetric("respdur")
                            .addTag("host",servicePath)
                            .addAggregator(AggregatorFactory.createAverageAggregator(1, org.kairosdb.client.builder.TimeUnit.MINUTES));
                    break;
                case("ten"):
                    calendar.set(Calendar.MINUTE,
                            calendar.get(Calendar.MINUTE) - (number*10));
                    queryBuilder.setStart(calendar.getTime())
                            .setEnd(currDate)
                            .addMetric("respdur")
                            .addTag("host",servicePath)
                            .addAggregator(AggregatorFactory.createAverageAggregator(10, org.kairosdb.client.builder.TimeUnit.MINUTES));
                    break;
                case("thirty"):
                    calendar.set(Calendar.MINUTE,
                            calendar.get(Calendar.MINUTE) - (number*30));
                    queryBuilder.setStart(calendar.getTime())
                            .setEnd(currDate)
                            .addMetric("respdur")
                            .addTag("host",servicePath)
                            .addAggregator(AggregatorFactory.createAverageAggregator(30, org.kairosdb.client.builder.TimeUnit.MINUTES));
                    break;
                case("hour"):
                    calendar.set(Calendar.HOUR,
                            calendar.get(Calendar.HOUR) - number);
                    queryBuilder.setStart(calendar.getTime())
                            .setEnd(currDate)
                            .addMetric("respdur")
                            .addTag("host",servicePath)
                            .addAggregator(AggregatorFactory.createAverageAggregator(1, org.kairosdb.client.builder.TimeUnit.HOURS));
                    break;
            }
            response = httpClient.query(queryBuilder);
            if(response.getQueries().size() > 0 ){
                dataPoints.addAll(response.getQueries().get(0).getResults().get(0).getDataPoints());
            }
        }
        return dataPoints;
    }

    public Map selectTopology(){
        Map count =  getErrorCountCluster();
        Map<String,String> total = (Map) count.get("total");
        Map<String,String> error = (Map) count.get("error");


        //修改total集合中服务名称：key的名字参照ServiceNameConfig文件
        List<ServiceNameUpdate> lists = serviceNameConfig.getServiceNameList();
        for (ServiceNameUpdate snu: lists){
            if (total.containsKey(snu.getOldServiceName())){
                total.put(snu.getServiceName(),total.remove(snu.getOldServiceName()));
            }
        }
        //修改error集合中服务名称：key的名字参照ServiceNameConfig文件
        for (ServiceNameUpdate snu: serviceNameConfig.getServiceNameList()){
            if (error.containsKey(snu.getOldServiceName())){
                error.put(snu.getServiceName(),error.remove(snu.getOldServiceName()));
            }
            if (error.containsKey(snu.getOldServiceName()+"msg")){
                error.put(snu.getServiceName()+"msg",error.remove(snu.getOldServiceName()+"msg"));
            }
        }

        Map result = new HashMap();
        List<FlowNode> flowNodes = flowDao.findNodeAll();
        List<FlowLine> flowLines = flowDao.findLineAll();
        List<TcpFlowLineDto> lineDtos = new ArrayList<>();
        List<TcpFlowNodeDto> nodeDtos = new ArrayList<>();
        for(FlowNode node : flowNodes){
            TcpFlowNodeDto nodeDto = new TcpFlowNodeDto();
            long faultCount=0;
            String errorCount = "0";
            String errorIp = "";
            String totalCount = "0";
            if(node.getServerPath()==null || node.getServerPath().isEmpty()){
                nodeDto.setCategory(node.getMark());
            }else{
                nodeDto.setCategory("clusterNormal");
                if(total.containsKey(node.getCluster_name())){
                    totalCount = String.valueOf(total.get(node.getCluster_name()));
                }
                if(error.containsKey(node.getCluster_name())){
                    errorCount = String.valueOf(error.get(node.getCluster_name()));
                    errorIp = String.valueOf(error.get(node.getCluster_name()+"msg"));
                    nodeDto.setCategory("clusterFault");
                }

                /* 错误数暂时不用 */
              /*  try {
                    faultCount = getFaultCount(node.getServerPath());
                    if(faultCount>0){
                        *//* machine浅色图标 clusterFault错误图标 clusterNormal正常图标 meaningless无意义 *//*
                        nodeDto.setCategory("clusterFault");
                    }else{
                        nodeDto.setCategory("clusterNormal");
                    }
                } catch (Exception e) {
                    faultCount = 0;
                }*/
            }
            nodeDto.setFaultCount((int) faultCount);
            nodeDto.setKey(node.getCluster_name());
            nodeDto.setDescription("服务异常数："+errorCount+"/"+totalCount+"\r\n"+errorIp);
            nodeDto.setUrl(node.getServerPath());
            nodeDto.setServerName(node.getCluster_name());
            nodeDto.setText(node.getCluster_name());
            nodeDto.setPos(node.getCoordinate());
            nodeDtos.add(nodeDto);
        }

        for(FlowLine line : flowLines){
            System.out.println(line.getCluster_name_left()+":"+line.getClusterNameRight());
            TcpFlowLineDto lineDto = new TcpFlowLineDto();
            lineDto.setFrom(line.getCluster_name_left());
            lineDto.setTo(line.getClusterNameRight());
            lineDto.setFromSpot(line.getCoordinateLeft());
            lineDto.setToSpot(line.getCoordinateRight());
            lineDto.setColor(line.getColor());
            String point = line.getPoints();
            if(point!=null && point.length()>0){
                point = point.substring(1,point.length()-1);
                point =  point.replaceAll("\\\\", "");
                point =  point.replaceAll("\"", "");
                List list = new ArrayList();
                String [] mapArray = point.split(",");
                for (int j = 0; j < mapArray.length; j++) {
                    list.add(Double.valueOf(mapArray[j]));
                }
                lineDto.setPoints(list);
            }else{
                lineDto.setPoints(null);
            }
            lineDtos.add(lineDto);
        }
        result.put("class", "GraphLinksModel");

        //修改托普通点的服务名称
//        for (int i = 0 ; i < nodeDtos.size() ; i++){
//            if (serviceNameConfig.getServiceName().containsKey(nodeDtos.get(i).getServerName())){
//                nodeDtos.get(i).setServerName(serviceNameConfig.getServiceName().get(nodeDtos.get(i).getServerName()));
//                nodeDtos.get(i).setKey(serviceNameConfig.getServiceName().get(nodeDtos.get(i).getKey()));
//                nodeDtos.get(i).setText(serviceNameConfig.getServiceName().get(nodeDtos.get(i).getText()));
//            }
//        }

        //修改拓扑图线的服务名称
//        for (int j = 0 ; j < lineDtos.size() ; j++){
//            if (serviceNameConfig.getServiceName().containsKey(lineDtos.get(j).getFrom())){
//                lineDtos.get(j).setFrom(serviceNameConfig.getServiceName().get(lineDtos.get(j).getFrom()));
//            }
//            if (serviceNameConfig.getServiceName().containsKey(lineDtos.get(j).getTo())){
//                lineDtos.get(j).setTo(serviceNameConfig.getServiceName().get(lineDtos.get(j).getTo()));
//            }
//        }

        //TODO 一会儿打开
        List<TcpFlowNodeDto> tcpFlowNodeDtos = initNodeDtos(nodeDtos);
//        List<TcpFlowNodeDto> tcpFlowNodeDtos1 = initGroup(tcpFlowNodeDtos);
        List<TcpFlowLineDto> tcpFlowLineDtos = initLineDtos(lineDtos);
        initGroup(tcpFlowNodeDtos);
//        for (int i=0;i<tcpFlowLineDtos.size();i++){
//            if (tcpFlowLineDtos.get(i).getTo().equals(".")){
//                tcpFlowLineDtos.get(i).setTo("接入区");
//                continue;
//            }
//            if (tcpFlowLineDtos.get(i).getTo().equals("..")){
//                tcpFlowLineDtos.get(i).setTo("核心业务区");
//                continue;
//            }
//            if (tcpFlowLineDtos.get(i).getTo().equals("...")){
//                tcpFlowLineDtos.get(i).setTo("算法区");
//                continue;
//            }
//        }
        result.put("nodeDataArray", tcpFlowNodeDtos);
        result.put("linkDataArray", tcpFlowLineDtos);
//        JSONArray jsonArrayNode = new JSONArray();
//        System.out.println("!!!!!!!!!!!!!!!!!!!!!!!!!!");
//        System.out.println(json.toString());
//        System.out.println("!!!!!!!!!!!!!!!!!!!!!!!!!!");
//        System.out.println("@@@@@@@@@@@@@@@@@@@@@@@@@@@@");
//        System.out.println(json.toString());
//        System.out.println("@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@");
//        //TODO 一会儿删掉
//        result.put("nodeDataArray", nodeDtos);
//        result.put("linkDataArray", lineDtos);
//        initGroup(nodeDtos);
        JSONObject json = JSONObject.fromObject(result);
//        System.out.println("####################");
//        System.out.println(json.toString());
//        System.out.println("####################");
       return result;
    }

    /**
     * 格式化点返回对象，配置isGroup与group属性，并添加六个分区
     * @param nodeDtos
     * @return
     */
    private List<TcpFlowNodeDto> initGroup(List<TcpFlowNodeDto> nodeDtos){
        Boolean b = null;
        String areaName = "";
        Boolean jrq = false;
        Boolean qxgl = false;
        Boolean jrgl = false;
        Boolean hxywq = false;
        Boolean sfq = false;
        Boolean rzhj = false;
        Boolean jiashuju1 = false;
        Boolean jiashuju2 = false;
        for (TcpFlowNodeDto tcpFlowNodeDto:nodeDtos){
            if (tcpFlowNodeDto.getServerName().equals("接入区")){
                jrq = true;
            }else if (tcpFlowNodeDto.getServerName().equals("核心业务区")){
                hxywq = true;
            }else if (tcpFlowNodeDto.getServerName().equals("算法区")){
                sfq = true;
            }else if (tcpFlowNodeDto.getServerName().equals("日志汇聚")){
                rzhj = true;
            }else if (tcpFlowNodeDto.getServerName().equals("权限管理")){
                qxgl = true;
            }else if (tcpFlowNodeDto.getServerName().equals("接入管理")){
                jrgl = true;
            }else if (tcpFlowNodeDto.getServerName().equals(".")){
                jiashuju1 = true;

            }else if (tcpFlowNodeDto.getServerName().equals("..")){
                jiashuju2 = true;
            }

            b = srConfig.getAllArea().containsKey(tcpFlowNodeDto.getServerName()) ? true : false;
            areaName = srConfig.getAreaName(tcpFlowNodeDto.getServerName());
            tcpFlowNodeDto.setIsGroup(b);
            tcpFlowNodeDto.setGroup(areaName);
        }
        TcpFlowNodeDto nodeDto = new TcpFlowNodeDto();
        //没有接入区添加区域配置
        if (!jrq){
            nodeDto = new TcpFlowNodeDto("接入区","serviceGroup",nodeDtos.get(0).getDescription(),nodeDtos.get(0).getDescriptionCss(),
                    nodeDtos.get(0).getPos(),"接入区","接入区",nodeDtos.get(0).getImgsrc(),nodeDtos.get(0).getCaption(),
                    nodeDtos.get(0).getTcpTransactionTotalCount(),nodeDtos.get(0).getErrorTcpTransactionTotalCount(),nodeDtos.get(0).getFaultCount(),
                    nodeDtos.get(0).getUrl(),true,"");
            nodeDtos.add(nodeDto);
        }
        //没有核心业务区添加区域配置
        if (!hxywq){
            nodeDto = new TcpFlowNodeDto("核心业务区","serviceGroup",nodeDtos.get(0).getDescription(),nodeDtos.get(0).getDescriptionCss(),
                    nodeDtos.get(0).getPos(),"核心业务区","核心业务区",nodeDtos.get(0).getImgsrc(),nodeDtos.get(0).getCaption(),
                    nodeDtos.get(0).getTcpTransactionTotalCount(),nodeDtos.get(0).getErrorTcpTransactionTotalCount(),nodeDtos.get(0).getFaultCount(),
                    nodeDtos.get(0).getUrl(),true,"");
            nodeDtos.add(nodeDto);
        }
        //没有算法区添加区域配置
        if (!sfq){
            nodeDto = new TcpFlowNodeDto("算法区","serviceGroup",nodeDtos.get(0).getDescription(),nodeDtos.get(0).getDescriptionCss(),
                    nodeDtos.get(0).getPos(),"算法区","算法区",nodeDtos.get(0).getImgsrc(),nodeDtos.get(0).getCaption(),
                    nodeDtos.get(0).getTcpTransactionTotalCount(),nodeDtos.get(0).getErrorTcpTransactionTotalCount(),nodeDtos.get(0).getFaultCount(),
                    nodeDtos.get(0).getUrl(),true,"");
            nodeDtos.add(nodeDto);
        }
        //没有日志汇聚添加区域配置
        if (!rzhj){
            nodeDto = new TcpFlowNodeDto("日志汇聚","serviceGroup",nodeDtos.get(0).getDescription(),nodeDtos.get(0).getDescriptionCss(),
                    nodeDtos.get(0).getPos(),"日志汇聚","日志汇聚",nodeDtos.get(0).getImgsrc(),nodeDtos.get(0).getCaption(),
                    nodeDtos.get(0).getTcpTransactionTotalCount(),nodeDtos.get(0).getErrorTcpTransactionTotalCount(),nodeDtos.get(0).getFaultCount(),
                    nodeDtos.get(0).getUrl(),true,"");
            nodeDtos.add(nodeDto);
        }
        //没有权限管理添加区域配置
        if (!qxgl){
            nodeDto = new TcpFlowNodeDto("权限管理","serviceGroup",nodeDtos.get(0).getDescription(),nodeDtos.get(0).getDescriptionCss(),
                    nodeDtos.get(0).getPos(),"权限管理","权限管理",nodeDtos.get(0).getImgsrc(),nodeDtos.get(0).getCaption(),
                    nodeDtos.get(0).getTcpTransactionTotalCount(),nodeDtos.get(0).getErrorTcpTransactionTotalCount(),nodeDtos.get(0).getFaultCount(),
                    nodeDtos.get(0).getUrl(),true,"接入区");
            nodeDtos.add(nodeDto);
        }
        //没有接入管理添加区域配置
        if (!jrgl){
            nodeDto = new TcpFlowNodeDto("接入管理","serviceGroup",nodeDtos.get(0).getDescription(),nodeDtos.get(0).getDescriptionCss(),
                    nodeDtos.get(0).getPos(),"接入管理","接入管理",nodeDtos.get(0).getImgsrc(),nodeDtos.get(0).getCaption(),
                    nodeDtos.get(0).getTcpTransactionTotalCount(),nodeDtos.get(0).getErrorTcpTransactionTotalCount(),nodeDtos.get(0).getFaultCount(),
                    nodeDtos.get(0).getUrl(),true,"接入区");
            nodeDtos.add(nodeDto);
        }
//        if (!jiashuju1){
//            nodeDto = new TcpFlowNodeDto(".","node1",nodeDtos.get(0).getDescription(),nodeDtos.get(0).getDescriptionCss(),
//                    nodeDtos.get(0).getPos(),".",".",nodeDtos.get(0).getImgsrc(),nodeDtos.get(0).getCaption(),
//                    nodeDtos.get(0).getTcpTransactionTotalCount(),nodeDtos.get(0).getErrorTcpTransactionTotalCount(),nodeDtos.get(0).getFaultCount(),
//                    nodeDtos.get(0).getUrl(),false,"日志汇聚");
//            nodeDtos.add(nodeDto);
//        }
//        if (!jiashuju2){
//            nodeDto = new TcpFlowNodeDto("..","node1",nodeDtos.get(0).getDescription(),nodeDtos.get(0).getDescriptionCss(),
//                    nodeDtos.get(0).getPos(),"..","..",nodeDtos.get(0).getImgsrc(),nodeDtos.get(0).getCaption(),
//                    nodeDtos.get(0).getTcpTransactionTotalCount(),nodeDtos.get(0).getErrorTcpTransactionTotalCount(),nodeDtos.get(0).getFaultCount(),
//                    nodeDtos.get(0).getUrl(),false,"日志汇聚");
//            nodeDtos.add(nodeDto);
//        }
        return nodeDtos;
    }

    /**
     * //去掉点集合中：照片比对（1对1）、身份核查（人证）、OCR识别引擎、虹膜识别引擎数据
     * @param nodeDtos
     * @return
     */
    private List<TcpFlowNodeDto> initNodeDtos(List<TcpFlowNodeDto> nodeDtos) {
        TcpFlowNodeDto next = null;
        Iterator<TcpFlowNodeDto> iteratorNode = nodeDtos.iterator();

        while (iteratorNode.hasNext()) {
            next = iteratorNode.next();
            if (next.getServerName().equals("虹膜识别引擎") || next.getServerName().equals("OCR识别引擎")
                    || next.getServerName().equals("身份核查（人证）") || next.getServerName().equals("照片比对（1对1）")){
                iteratorNode.remove();
            }
        }
        return nodeDtos;
    }

    /**
     * //去掉线集合中：照片比对（1对1）、身份核查（人证）、OCR识别引擎、虹膜识别引擎数据
     * @param lineDtos
     * @return
     */
    private List<TcpFlowLineDto> initLineDtos(List<TcpFlowLineDto> lineDtos) {
        TcpFlowLineDto next = null;
        Iterator<TcpFlowLineDto> iteratorLine = lineDtos.iterator();
        while(iteratorLine.hasNext()) {
            next = iteratorLine.next();
            if (next.getFrom().equals("虹膜识别引擎") || next.getFrom().equals("OCR识别引擎")
                    || next.getFrom().equals("身份核查（人证）") || next.getFrom().equals("照片比对（1对1）")
                    || next.getTo().equals("虹膜识别引擎") || next.getTo().equals("OCR识别引擎")
                    || next.getTo().equals("身份核查（人证）") || next.getTo().equals("照片比对（1对1）")){
                iteratorLine.remove();
            }

        }
        return lineDtos;
    }

    private long getFaultCount(String servicePath) throws IOException, DataFormatException {
        Aggregator aggregatorDay = AggregatorFactory.createSumAggregator(1, org.kairosdb.client.builder.TimeUnit.DAYS).withStartTimeAlignment(0);
        QueryBuilder queryBuilder = QueryBuilder.getInstance();
        queryBuilder.setStart(1, org.kairosdb.client.builder.TimeUnit.DAYS).setTimeZone(TimeZone.getDefault())
                .addMetric("heartbeat")
                .addTag("host", servicePath)
                .addAggregator(aggregatorDay);
        QueryResponse response = httpClient.query(queryBuilder);
        List<DataPoint> dataPointsDay = response.getQueries().get(0).getResults().get(0).getDataPoints();
        return dataPointsDay.size() == 0 ? 0 : dataPointsDay.get(dataPointsDay.size() - 1).longValue();
    }

    public Map saveTopology(String json) {
        JSONObject jsonObject = JSONObject.fromObject(json);
        List<JSONObject> nodeList = jsonObject.getJSONArray("nodeDataArray");
        List<JSONObject> linkList = jsonObject.getJSONArray("linkDataArray");
        for(JSONObject js : nodeList){
            if(!js.isNullObject()){
                flowDao.updateNode(js.getString("serverName"),js.getString("pos"), js.getString("category"));
            }
        }
        for(JSONObject js : linkList){
            if(!js.isNullObject()){
                flowDao.updateLine(js.getString("from"),js.getString("to"), js.getString("points"),js.getString("color"));
            }
        }
        Map result = new HashMap();
        result.put("state",true);
        /*线程池*/
        return result;
    }


    public JSONObject getStatistics() {
        Server_Host_Info serverHostInfo = cassandraDao.getStatisticsUri();
        Map<String, String> map = SendHttpUtil.doGet(serverHostInfo.getService_path());
        JSONObject json = JSONObject.fromObject(map.get("body"));
        return json;
    }
    public Map<String,Map> getErrorCountCluster() {
        /*线程池*/
        ExecutorService service = Executors.newFixedThreadPool(THREADPOOLSIZE);
        List<Server_Host_Info> hostInfoList = authModeAndHostList.getClusterBeMonitoredList();
        Map totalMap = new HashMap();
        Map errorMap = new HashMap();
        for (Server_Host_Info hostInfo : hostInfoList) {
            if(totalMap.containsKey(hostInfo.getCluster_name())){
                // map中存在 取出原先值 +1  然后覆盖原有的
                int total = Integer.parseInt(String.valueOf(totalMap.get(hostInfo.getCluster_name()))) + 1 ;
                totalMap.put(hostInfo.getCluster_name(),total);
            }else{
                // map中没有 就新建一个  默认值是1
                totalMap.put(hostInfo.getCluster_name(),1);
            }
            Future<SingleHostStatus> result = service.submit(new QueryHostStatusTask(hostInfo, httpClient));
            try {
                SingleHostStatus singleHostStatus = result.get();
                Map<String, Object> hostStatus = singleHostStatus.getHostStatus();
                String flag = "ok";
                if(!flag.equals(hostStatus.get("value"))){
                    if(errorMap.containsKey(hostInfo.getCluster_name())){
                        // map中存在 取出原先值 +1  然后覆盖原有的
                        int total = Integer.parseInt(String.valueOf(errorMap.get(hostInfo.getCluster_name()))) + 1 ;
                        errorMap.put(hostInfo.getCluster_name(),total);
                    }else{
                        // map中没有 就新建一个  默认值是1
                        errorMap.put(hostInfo.getCluster_name(),1);
                    }
                    /*记录错误IP*/
                    if(errorMap.containsKey(hostInfo.getCluster_name()+"msg")){
                        // map中存在 取出原先值 +1  然后覆盖原有的
//                        errorMap.put(hostInfo.getCluster_name()+"msg",errorMap.get(hostInfo.getCluster_name()+"msg")
//                                +"<div>"+hostInfo.getHost_ip()+"</div>");
                        errorMap.put(hostInfo.getCluster_name()+"msg",errorMap.get(hostInfo.getCluster_name()+"msg")
                                +hostInfo.getHost_ip()+"\r\n");
                    }else{
                        // map中没有 就新建一个  默认值是1
//                        errorMap.put(hostInfo.getCluster_name()+"msg","<div>"+hostInfo.getHost_ip()+"</div>");
                        errorMap.put(hostInfo.getCluster_name()+"msg",hostInfo.getHost_ip()+"\r\n");
                    }

                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
        Map<String,Map> map  = new HashMap();
        map.put("total",totalMap);
        map.put("error",errorMap);
        return map;
    }





    public Map changeSwitch(String json) {
        JSONObject jsonObject = JSONObject.fromObject(json);
        String currState = jsonObject.getString("state");
        boolean flag =false;
        if(currState.equals("close")){
            flag = cassandraDao.changeSwitch("open");
            TokenInterceptor.currSwitch = true;
        }else if(currState.equals("open")){
            flag = cassandraDao.changeSwitch("close");
            TokenInterceptor.currSwitch = false;
        }
        Map map = new HashMap();
        map.put("state",flag);
        return map;
    }

    public Map getSwitch() {
        Map map = new HashMap();
        if(TokenInterceptor.currSwitch){
            map.put("switch","open");
        }else{
            map.put("switch","close");
        }
        return map;
    }

    public Map<String, Object> searchLog(String json) {
        Map<String,Object> map = new HashMap();
        JSONObject jsonObject  = JSONObject.fromObject(json);
        int pageNum = jsonObject.getInt("pageNum");
        int pageSize = jsonObject.getInt("pageSize");
        int subStart = 0 ;
        int subEnd = pageNum * pageSize;
        if (pageNum == 1){
            subStart = 0;
        }else{
            subStart = (pageNum - 1) * pageSize;
        }
        String ip = jsonObject.getString("ip");
        String start = jsonObject.getString("start");
        String end = jsonObject.getString("end");
        //响应结果前不需要的数据（要查页数之前的数据）
        List<AlarmLog> alarmLogByParam = null;
        //最后响应的查询结果
        List<AlarmLog> alarmLogList = null;
        long startCurrent = System.currentTimeMillis();
        if((!start.isEmpty())&&(!ip.isEmpty())&&!ip.equals("")&&!start.equals("")){
            //统计符合条件的记录总条数
            Map total = cassandraDao.getAlarmLogSize(ip,start,end);
            alarmLogList = cassandraDao.getAlarmLogByParam(ip, start, end);
            if (alarmLogList != null){
                //查询结果非空List升序排序（根据AlarmMsg::getAlatime）
                alarmLogList = alarmLogList.stream().sorted(Comparator.comparing(AlarmLog::getAlatime)).collect(Collectors.toList());
                //反转list排序
                Collections.reverse(alarmLogList);
            }
            //最后一个数据不足一页的，显示到list最后可以
            if (alarmLogList.size() > subStart && alarmLogList.size() < subEnd){
                alarmLogList =  alarmLogList.subList(subStart ,alarmLogList.size() - 1);
            }
            //查询结果足够最后一个显示
            if (alarmLogList.size() >= subEnd){
                alarmLogList = alarmLogList.subList(subStart , subEnd);
            }

            map.put("log",alarmLogList);
            map.put("logSize",total.get("count"));
        }else if(!start.isEmpty() && !start.equals("")){
            Map total = cassandraDao.getAlarmLogSize(start,end);
            alarmLogList = cassandraDao.getAlarmLogByStartAndEnd(start,end);
            if (alarmLogList != null){
                //查询结果非空List升序排序（根据AlarmMsg::getAlatime）
                alarmLogList = alarmLogList.stream().sorted(Comparator.comparing(AlarmLog::getAlatime)).collect(Collectors.toList());
                //反转list排序
                Collections.reverse(alarmLogList);
            }
            //最后一个数据不足一页的，显示到list最后可以
            if (alarmLogList.size() > subStart && alarmLogList.size() < subEnd){
                alarmLogList =  alarmLogList.subList(subStart ,alarmLogList.size() - 1);
            }
            //查询结果足够最后一个显示
            if (alarmLogList.size() >= subEnd){
                alarmLogList = alarmLogList.subList(subStart , subEnd);
            }

            map.put("log",alarmLogList);
            map.put("logSize",total.get("count"));
        }else if(!ip.isEmpty()&& !ip.equals("")){
            Map total = cassandraDao.getAlarmLogSize(ip);
            alarmLogList = cassandraDao.getAlarmLogByIp(ip);
            if (alarmLogList != null){
                //查询结果非空List升序排序（根据AlarmMsg::getAlatime）
                alarmLogList = alarmLogList.stream().sorted(Comparator.comparing(AlarmLog::getAlatime)).collect(Collectors.toList());
                //反转list排序
                Collections.reverse(alarmLogList);
            }
            //最后一个数据不足一页的，显示到list最后可以
            if (alarmLogList.size() > subStart && alarmLogList.size() < subEnd){
                alarmLogList =  alarmLogList.subList(subStart ,alarmLogList.size() - 1);
            }
            //查询结果足够最后一个显示
            if (alarmLogList.size() >= subEnd){
                alarmLogList = alarmLogList.subList(subStart , subEnd);
            }

            map.put("log",alarmLogList);
            map.put("logSize",total.get("count"));
        }else {
            Map total = cassandraDao.getAlarmLogSize();
            alarmLogList = cassandraDao.getAlarmLogList();
            //最后一个数据不足一页的，显示到list最后可以
            if (alarmLogList.size() > subStart && alarmLogList.size() < subEnd){
                alarmLogList =  alarmLogList.subList(subStart ,alarmLogList.size() - 1);
            }
            //查询结果足够最后一个显示
            if (alarmLogList.size() >= subEnd){
                alarmLogList = alarmLogList.subList(subStart , subEnd);
            }

            map.put("log",alarmLogList);
            map.put("logSize",total.get("count"));
        }
        return map;
    }
    //新建（Server_host_info）监控服务信息
    public String insertServerHostInfo(String json){
        JSONObject job = JSONObject.fromObject(json);
        Server_Host_Info server_host_info = new Server_Host_Info(job.getString("service_method"),job.getString("cluster_name"),
                job.getString("host_name"),job.getString("service_path"),job.getString("host_ip"),
                Short.parseShort(job.getString("host_port")),job.getString("request_body"),job.getString("response_body"),
                job.getString("service_password"),job.getString("layer"));
        cassandraDao.insertServerHostInfo(server_host_info);
        return server_host_info.toString();
    }

    //删除（Server_host_info）监控服务信息
    public String delServerHostInfo(String json){
        JSONObject job = JSONObject.fromObject(json);
        Server_Host_Info server_host_info = new Server_Host_Info(job.getString("service_method"),job.getString("cluster_name"),
                job.getString("host_name"),job.getString("service_path"),job.getString("host_ip"),
                Short.parseShort(job.getString("host_port")),job.getString("request_body"),job.getString("response_body"),
                job.getString("service_password"),job.getString("layer"));
        cassandraDao.delServerHostInfo(server_host_info);
        return server_host_info.toString();
    }

    //修改（Server_host_info）监控服务信息
    public String updateServerHostInfo(String json){
        JSONObject job = JSONObject.fromObject(json);
        Server_Host_Info server_host_info = new Server_Host_Info(job.getString("service_method"),job.getString("cluster_name"),
                job.getString("host_name"),job.getString("service_path"),job.getString("host_ip"),
                Short.parseShort(job.getString("host_port")),job.getString("request_body"),job.getString("response_body"),
                job.getString("service_password"),job.getString("layer"));
        cassandraDao.updateServerHostInfo(server_host_info);
        return server_host_info.toString();
    }

    public static void main(String[] args) {
        //测试修改map的key值
//        Map<String,String> total = new HashMap<>();
//        Map<String,String> error = new HashMap<>();
//        total.put("a","1");
//        total.put("b","2");
//        total.put("c","3");
//        error.put("a"+"msg","1");
//        error.put("b"+"msg","2");
//        error.put("c"+"msg","3");
//        System.out.println("############################");
//
//        for (String key : total.keySet()) {
//
//            System.out.println("Key = " + key);
//
//        }
//        System.out.println("############################");
//        System.out.println(total.toString());
//        System.out.println(error.toString());
//        total.put("d",total.remove("a"));
//        error.put("d"+"msg",error.remove("a"+"msg"));
//        System.out.println(total.toString());
//        System.out.println(error.toString());
        //之前的测试内容
        List<String> m = new ArrayList<>();
        m.add("a");
        m.add("b");
        m.add("c");
        m.add("d");
        m.add("e");
        m.add("f");
        String next = "";
        System.out.println(m.toString());
        Iterator<String> iterator = m.iterator();
        while (iterator.hasNext()) {
            next = iterator.next();
            if (next.equals("a") || next.equals("f")){
                iterator.remove();
            }
        }
        System.out.println(m);
        //之前的测试内容
//        cassandraDaoStatic.insertServerHostInfo();
//        System.out.println("@@@@@@@@@@@@@@@@@@@@");


    }

//    public Map<String, Object> searchLog(String json) {
//        Map<String,Object> map = new HashMap();
//
//        JSONObject jsonObject  = JSONObject.fromObject(json);
//        int pageNum = jsonObject.getInt("pageNum");
//        int pageSize = jsonObject.getInt("pageSize");
//        String ip = jsonObject.getString("ip");
//        String start = jsonObject.getString("start");
//        String end = jsonObject.getString("end");
//        List<AlarmLog> logList = cassandraDao.getAlarmLogList();
//        long flag = System.currentTimeMillis();
//        if((!start.isEmpty())&&(!ip.isEmpty())){
//
//            Map total = cassandraDao.getAlarmLogSize(ip,start,end);
//            List<AlarmLog> alarmList = null;
//
//            int i = 0;
//            do{
//                alarmList = cassandraDao.getAlarmLogList(ip,start,end, pageSize,flag);
//                if (logList.size()==0){
//                    break;
//                }
//                AlarmLog alarmLog = logList.get(logList.size()-1);
//                flag = alarmLog.getSerialnum();
//                i++;
//            }while(i<pageNum);
//            //查询结果非空List升序排序（根据AlarmMsg::getAlatime）
//            alarmList = alarmList.stream().sorted(Comparator.comparing(AlarmLog::getAlatime)).collect(Collectors.toList());
//            //反转list排序
//            Collections.reverse(alarmList);
//            map.put("log",alarmList);
//            map.put("logSize",total.get("count"));
//        }else if(!start.isEmpty()){
//            Map total = cassandraDao.getAlarmLogSize(start,end);
//            List<AlarmLog> alarmList = null;
//            int i = 0;
//            do{
//                alarmList = cassandraDao.getAlarmLogList(start,end,pageSize,flag);
//                if (logList.size()==0){
//                    break;
//                }
//                AlarmLog alarmLog = logList.get(logList.size()-1);
//                flag = alarmLog.getSerialnum();
//                i++;
//            }while(i<pageNum);
//            //查询结果非空List升序排序（根据AlarmMsg::getAlatime）
//            alarmList = alarmList.stream().sorted(Comparator.comparing(AlarmLog::getAlatime)).collect(Collectors.toList());
//            //反转list排序
//            Collections.reverse(alarmList);
//            map.put("log",alarmList);
//            map.put("logSize",total.get("count"));
//
//        }else if(!ip.isEmpty()){
//            List<AlarmLog> alarmList = null;
//            Map total = cassandraDao.getAlarmLogSize(ip);
//            int i = 0;
//            do{
//                alarmList = cassandraDao.getAlarmLogList(ip,pageSize,flag);
//                if (logList.size()==0){
//                    break;
//                }
//                AlarmLog alarmLog = logList.get(logList.size()-1);
//                flag = alarmLog.getSerialnum();
//                i++;
//            }while(i<pageNum);
//            //查询结果非空List升序排序（根据AlarmMsg::getAlatime）
//            alarmList = alarmList.stream().sorted(Comparator.comparing(AlarmLog::getAlatime)).collect(Collectors.toList());
//            //反转list排序
//            Collections.reverse(alarmList);
//            map.put("log",alarmList);
//            map.put("logSize",total.get("count"));
//        }else{
//            Map total = cassandraDao.getAlarmLogSize();
//            List<AlarmLog> alarmList = null;
//            int i = 0;
//            do{
//                alarmList = cassandraDao.getAlarmLog(pageSize,flag);
//                if (logList.size()==0){
//                    break;
//                }
////                //查询结果非空List升序排序（根据AlarmMsg::getAlatime）
////                alarmList = alarmList.stream().sorted(Comparator.comparing(AlarmLog::getAlatime)).collect(Collectors.toList());
////                //反转list排序
////                Collections.reverse(alarmList);
//                AlarmLog alarmLog = logList.get(logList.size()-1);
//                flag = alarmLog.getSerialnum();
//                i++;
//            }while(i<pageNum);
//            //查询结果非空List升序排序（根据AlarmMsg::getAlatime）
//            alarmList = alarmList.stream().sorted(Comparator.comparing(AlarmLog::getAlatime)).collect(Collectors.toList());
//            //反转list排序
//            Collections.reverse(alarmList);
//            map.put("log",alarmList);
//            map.put("logSize",total.get("count"));
//        }
//        return map;
//    }


    /*
    public Map selectClusterStatus() {
        List<Server_Host_Info> host_info_List = authModeAndHostList.getClusterBeMonitoredList();
        List<Server_Host_Info> accessList = new ArrayList<>();
        List<Server_Host_Info> serviceList = new ArrayList<>();
            for(Server_Host_Info hostInfo : host_info_List){
            if (hostInfo.getLayer().equals("接入区")){
                accessList.add(hostInfo);
            }else {
                serviceList.add(hostInfo);
            }
        }
        Map accessMap = selectClusterStatusBylayer(accessList);
        Map serviceMap = selectClusterStatusBylayer(serviceList);
        Map map  = new HashMap();
            map.put("接入区",accessMap);
            map.put("服务区",serviceMap);
            return map;
    }

    public Map selectClusterStatusBylayer(List<Server_Host_Info> host_info_List){
        List<SingleHostStatus> hostStatusList = new ArrayList<>();
        List<Future> futureList = new ArrayList<>();


        ExecutorService service = Executors.newFixedThreadPool(THREADPOOLSIZE);

        for (Server_Host_Info hostInfo : host_info_List) {
            Future<SingleHostStatus> result = service.submit(new QueryHostStatusTask(hostInfo, httpClient));
            futureList.add(result);
        }
        service.shutdown();
        try {
            if (service.awaitTermination(3, TimeUnit.MINUTES)) {
                for (Future future : futureList) {
                    SingleHostStatus singleHostStatus = (SingleHostStatus) future.get();
                    hostStatusList.add(singleHostStatus);
                }
            }
        } catch (InterruptedException | ExecutionException e) {
            e.printStackTrace();
        }
        if (hostStatusList.size() != 0) {
            Map<String, Object> clusterStatus = new HashMap<>();
            Map<String, List<SingleHostStatus>> listMap = hostStatusList.stream().collect(Collectors.groupingBy(SingleHostStatus::getClusterName));
            for (Map.Entry<String, List<SingleHostStatus>> singleClusterStatusEntry : listMap.entrySet()) {
                String clusterName = singleClusterStatusEntry.getKey();
                Map<String, Object> singleClusterStatus = new HashMap<>();
                List<SingleHostStatus> singleHostStatusList = singleClusterStatusEntry.getValue();
                for (SingleHostStatus singleHostStatus : singleHostStatusList) {
                    singleClusterStatus.put(singleHostStatus.getHostName(), singleHostStatus.getHostStatus());
                }
                clusterStatus.put(clusterName, singleClusterStatus);
            }
            return clusterStatus;
        }
        return null;
    }
    * */

//    /**
//     * 获取一包基准值
//     * @return 基准值实体类
//     */
//    public List<CTID_Request_Perf_BaseLineValue> getReqBLV() {
//        return cassandraDao.getReqBLV();
//    }
//
//    /**
//     * 获取二包基准值
//     * @return 基准值实体类
//     */
//    public List<CTID_Process_Perf_BaseLineValue> getProBLV() {
//        return cassandraDao.getProBLV();
//    }
//
//    /**
//     * 更新一包性能基准值
//     * @param entity 新的一包基准值
//     * @return 更新成功返回的基准值
//     */
//    public List<CTID_Request_Perf_BaseLineValue> updateReqBLV(CTID_Request_Perf_BaseLineValue entity) {
//        cassandraDao.saveReqBLV(entity);
//        return cassandraDao.getReqBLV();
//    }
//
//    /**
//     * 更新二包性能基准值
//     * @param entity 新的二包基准值
//     * @return 更新成功返回的基准值
//     */
//    public List<CTID_Process_Perf_BaseLineValue> updateProBLV(CTID_Process_Perf_BaseLineValue entity) {
//        cassandraDao.saveProBLV(entity);
//        return cassandraDao.getProBLV();
//    }
/*public static void main(String[] args) {
    long time = 1607304515793L;
    Date date = new Date(time);
    SimpleDateFormat sdf = new SimpleDateFormat("yyyy MM dd hh:mm:ss");
    System.out.println(sdf.format(date));
}*/


}
