package com.yingxin.prms.service.asyncTask;


import com.yingxin.prms.config.Constant;
import com.yingxin.prms.domain.AlarmMsg;
import com.yingxin.prms.domain.Auth_Mode_Avg;
import com.yingxin.prms.service.business.Manager;
import com.yingxin.prms.service.dao.AuthModeAvgImpl;
import com.yingxin.prms.service.dao.AuthSuccessRateImpl;
import com.yingxin.prms.service.dao.CassandraDaoImpl;
import com.yingxin.prms.utils.TimeUtil;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @Author by shao
 * @Create 2023/3/1 17:05
 */
@Component
public class PortraitCheckTimeTask {
    private static Logger logger = LoggerFactory.getLogger(PortraitCheckTimeTask.class);
    @Autowired
    AuthModeAvgImpl authModeAvgIml;
    @Autowired
    CassandraDaoImpl cassandraDao;
    @Value("${auth_time_avg_url}")
    private String url;
    @Value("${authorization}")
    private String authorization;
    @Value("${avg_point}")
    private double avgPoint;
    private boolean status;
    /**
     * 获取生物识别平台 认证平均耗时
     *
     * @param modes 模式集合
     * @param begin 开始时间（用来记录读取时间）
     * @param end   结束时间
     * @param type  类型 1：最近100条请求的平均耗时，此时begin和end的值无效   非1：规定时间内所有请求耗时
     */
    @Async("asyncTaskPool")
    public void doTask(List<String> modes, String begin, String end, String type) {

        List<Auth_Mode_Avg> authModeAvgList = new ArrayList<>();
        for (int i = 0; i < modes.size(); i++) {
            status = false;
            try {
                //配置参数
                Map params = new HashMap();
                params.put("mode", modes.get(i));
                params.put("begin", begin);
                params.put("end", end);
                params.put("type", type);
                //设置信息头
                HttpHeaders headers = new HttpHeaders();
                headers.add("authorization", authorization);
                HttpEntity httpEntity = new HttpEntity<>(params, headers);
                //发送http post请求
                RestTemplate restTemplate = new RestTemplate();
                restTemplate.getMessageConverters().set(1, new StringHttpMessageConverter(StandardCharsets.UTF_8));
                String account = restTemplate.postForObject(url, httpEntity, String.class);

                JSONObject json = StringToJson(account);
                //将返回结果插入到cassandra.auth_mode_avg
                if (json != null && json.has("data") && !json.getString("data").equals("null") && json.getJSONObject("data").has("busTimeAvg")) {
                    status = true;
                    Auth_Mode_Avg ama = new Auth_Mode_Avg(modes.get(i), begin + "", json.getJSONObject("data").getString("busTimeAvg"));
                    //测试数据存入cassandra
                    insertToCassandra(ama);
                    //将总耗时整理以备后续存入数据库
                    authModeAvgList.add(ama);
                    //判断本次是否需要插入告警数据
                    insertAlarmMag(ama);
                } else {
                    logger.info("暂无数据！");
//                    System.out.println("暂无数据！");
                }
            } catch (Exception e) {
                logger.error("error: portraitCheckTimeTask to {}", modes.get(i));
                logger.error(e.getMessage());
                AlarmMsg alarmMsg = new AlarmMsg();
                alarmMsg.setAlarmLevel(Constant.ALARM_UNSTABLE);
                alarmMsg.setState("1");
                alarmMsg.setAlarmMessage("调用："+url+" 返回数据异常");
                alarmMsg.setClusterName("");
                alarmMsg.setIp("0.0.0.0");
                alarmMsg.setPort("");
                alarmMsg.setAlatime(TimeUtil.getDate());
                alarmMsg.setSerialnum(0L);
                cassandraDao.insertAlarmMsg(alarmMsg);
            }
        }
        //插入总平均耗时 如果日志系统有返回数据并且不为null并且不为空串则可以将返回结果添加到数据库中
        if (status){
            insertTotalAuthTimeAvg(authModeAvgList);
            status = false;
        }
    }

    /**
     * 模式耗时数据入库
     *
     * @param authModeAvg
     */
    private void insertToCassandra(Auth_Mode_Avg authModeAvg) {
        authModeAvgIml.save(authModeAvg);
    }

    /**
     * 字符串转成Json格式
     *
     * @param data
     * @return
     */
    private JSONObject StringToJson(String data) {
        JSONObject json;
        if (data != null && !data.equals("")) {
            json = JSONObject.fromObject(data);
        } else {
            json = null;
        }
        return json;
    }

    /**
     * 统计总耗时并记录到数据库(1:N  M:N  总平均耗时)
     * @param authModeAvgList
     */
    private void insertTotalAuthTimeAvg(List<Auth_Mode_Avg> authModeAvgList) {
        double timeTotal = 0.00;
        for (int i = 0; i < authModeAvgList.size(); i++) {
            timeTotal = timeTotal + Double.valueOf(authModeAvgList.get(i).getTime_avg());
        }
        if (timeTotal > 0) {
            insertToCassandra(new Auth_Mode_Avg("ALL-MODE", authModeAvgList.get(0).getTimestamp(), timeTotal / authModeAvgList.size() + ""));
        }
    }

    //判断本次告警数据是否有效并且同上次测试数据性能下降了40%。
    public void insertAlarmMag(Auth_Mode_Avg authModeAvg){
        List<Auth_Mode_Avg> authModeAvgList = authModeAvgIml.findLineChartTimelim1(authModeAvg.getMode());
        Double avgNew = null;
        Double avgOlg = null;

        if (authModeAvgList != null && authModeAvgList.size() > 0 && authModeAvgList.get(0).getTime_avg().indexOf(".")>0){
            avgOlg = Double.valueOf(authModeAvgList.get(0).getTime_avg());
        }
        if (authModeAvg != null && authModeAvg.getTime_avg().indexOf(".")>0){
            avgNew = Double.valueOf(authModeAvgList.get(0).getTime_avg());
        }
        if (avgNew != null && avgOlg != null){
            if((avgNew - avgOlg) / avgOlg > avgPoint){
                AlarmMsg alarmMsg = new AlarmMsg();
                alarmMsg.setAlarmLevel("unstable");
                alarmMsg.setState("1");
                alarmMsg.setAlarmMessage(authModeAvgList.get(0).getMode()+"模式在最近的平均耗时为："+avgNew+" 。对比前一分钟，性能下降过快");
                alarmMsg.setClusterName("");
                alarmMsg.setIp("0.0.0.0");
                alarmMsg.setPort("");
                alarmMsg.setAlatime(authModeAvgList.get(0).getTimestamp());
                alarmMsg.setSerialnum(0L);
                logger.info("插入平均耗时性能下降告警！");
                cassandraDao.insertAlarmMsg(alarmMsg);
            }
        }
    }

}
