package com.yingxin.prms.service.asyncTask;


import com.google.gson.JsonArray;
import com.sun.scenario.effect.impl.sw.java.JSWBlend_SRC_OUTPeer;
import com.yingxin.prms.config.Constant;
import com.yingxin.prms.domain.AlarmMsg;
import com.yingxin.prms.service.dao.CassandraDaoImpl;
import com.yingxin.prms.utils.TimeUtil;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @Author by shao
 * @Create 2023/3/1 17:05
 */
@Component
public class LogSystemAlarmTask {
    private static Logger logger = LoggerFactory.getLogger(LogSystemAlarmTask.class);
    @Autowired
    CassandraDaoImpl cassandraDao;
    @Value("${log_statistics_url}")
    private String url;
    @Value("${authorization}")
    private String authorization;

    @Value("${error_rate}")
    private double errorRate;

    @Async("asyncTaskPool")
    public void doTask(String appid,Long begin,Long end){
        System.out.println();
        try {
            //设置信息头
            HttpHeaders headers = new HttpHeaders();
            headers.add("Authorization", authorization);
            HttpEntity httpEntity = new HttpEntity<>(headers);
            //发送http get请求
            RestTemplate restTemplate = new RestTemplate();
            restTemplate.getMessageConverters().set(1, new StringHttpMessageConverter(StandardCharsets.UTF_8));
            ResponseEntity<String> data = restTemplate.exchange(url+"?appid="+appid+"&&gte="+begin+"&&lte="+end,
                    HttpMethod.GET, httpEntity, String.class);
            JSONObject json = StringToJson(data.getBody());
            //将返回结果插入到cassandra.auth_mode_avg
            if (json != null && json.has("data") && !json.getString("data").equals("null")) {
                JSONArray jsonArray = json.getJSONArray("data");
                double totalCount = 0.0;
                double esCount = 0.0;
                for (int i = 0;i<jsonArray.size();i++){
                    totalCount = totalCount+(int) jsonArray.getJSONObject(i).get("doc_count");
                    if (jsonArray.getJSONObject(i).getString("key").length()>=2 && jsonArray.getJSONObject(i).getString("key").substring(0,2).equals("ES")){
                        esCount = esCount+(int) jsonArray.getJSONObject(i).get("doc_count");
                    }
                }
                System.out.println(json.toString());
                System.out.println("totalCount: "+ totalCount);
                System.out.println("esCount: " + esCount);
                System.out.println("异常率： "+esCount/totalCount);
                if (totalCount!=0 && esCount/totalCount>=errorRate){
                    AlarmMsg alarmMsg = new AlarmMsg();
                    alarmMsg.setAlarmLevel(Constant.ALARM_UNSTABLE);
                    alarmMsg.setState("1");
                    alarmMsg.setAlarmMessage("调用:"+url+" 系统异常日志统计超过"+errorRate+"%");
                    alarmMsg.setClusterName("");
                    alarmMsg.setIp("0.0.0.0");
                    alarmMsg.setPort("");
                    alarmMsg.setAlatime(TimeUtil.getDate());
                    alarmMsg.setSerialnum(0L);
                    System.out.println(alarmMsg.toString());
                    System.out.println("插入日志异常数据到数据库中！！！！！！！！！！！！！！！");
                    cassandraDao.insertAlarmMsg(alarmMsg);
                }
            } else {
                logger.info("暂无数据或者异常未超过1%！");
            }

        } catch (Exception e) {
            System.out.println("出现异常情况");
            System.out.println(e.getMessage());
            logger.error("error: logSystemAlarmTask to {}", "dotask");
            e.printStackTrace();
        }
    }
    public void insertAuthTimeAvg() {

    }
    /**
     * 字符串转成Json格式
     *
     * @param data
     * @return
     */
    private JSONObject StringToJson(String data) {
        JSONObject json;
        if (data != null && !data.equals("")) {
            json = JSONObject.fromObject(data);
        } else {
            json = null;
        }
        return json;
    }

    public static void main(String[] args) {
        double a = 1;
        double b = 1;
        double c = 1;
        a=a+c;
        System.out.println(a>c);
        System.out.println(a);
        System.out.println(a/b);
    }


}
