package com.yingxin.prms.service.asyncTask;


import com.datastax.driver.core.querybuilder.Using;
import com.yingxin.prms.domain.AlarmMsg;
import com.yingxin.prms.domain.Auth_Mode_Avg;
import com.yingxin.prms.domain.Auth_Success_Rate;
import com.yingxin.prms.dto.SuccessRate;
import com.yingxin.prms.service.dao.AuthSuccessRateImpl;
import com.yingxin.prms.service.dao.CassandraDaoImpl;
import com.yingxin.prms.utils.TimeUtil;
import net.sf.json.JSONObject;
import org.checkerframework.checker.units.qual.A;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @Author by shao
 * @Create 2023/3/1 17:05
 */
@Component
public class AuthSuccessRateTask {
    private static Logger logger = LoggerFactory.getLogger(AuthSuccessRateTask.class);
    @Value("${auth_success_rate_url}")
    String url;
    @Value("${authorization}")
    String authorization;
    @Value("${success_ point}")
    double successPoint;
    String appid = "";
    boolean status;
    @Autowired
    AuthSuccessRateImpl authSuccessRateImpl;
    @Autowired
    CassandraDaoImpl cassandraDao;

    /**
     * 获取生物识别平台 认证成功率
     *
     * @param modes 模式
     * @param begin 开始时间（用来记录读取时间）
     * @param end   结束时间 (结束时间不填时，查询从开始时间大到当前的数据）
     * @param appid appid项为空时（不传）查所有应用
     */
    @Async("asyncTaskPool")
    public void doTask(List<String> modes, String begin, String end, String appid) {
        List<Auth_Success_Rate> authSuccessRateList = new ArrayList<>();
        status = false;
        for (int i = 0; i < modes.size(); i++) {
            try {
                //配置参数
                Map params = new HashMap();
                params.put("appid", appid);
                params.put("mode", modes.get(i));
                params.put("begin", begin);
                params.put("end", end);

                //设置信息头
                HttpHeaders headers = new HttpHeaders();
                headers.add("authorization", authorization);
                HttpEntity httpEntity = new HttpEntity<>(params, headers);
                //发送http post请求
                RestTemplate restTemplate = new RestTemplate();
                restTemplate.getMessageConverters().set(1, new StringHttpMessageConverter(StandardCharsets.UTF_8));
                String account = restTemplate.postForObject(url, httpEntity, String.class);

                JSONObject json = StringToJson(account);
                //将返回结果插入到cassandra.auth_mode_avg
                if (json != null && json.has("data") && !json.getString("data").equals("null")) {
                    status = true;
                    JSONObject jsonData = json.getJSONObject("data");
                    logger.info("################# 成功率比对 入库显示 ##########################");
                    Auth_Success_Rate asr = new Auth_Success_Rate(modes.get(i), TimeUtil.toDate(Long.valueOf(begin)) + "", jsonData.getString(String.valueOf(SuccessRate.halfAnHour)), jsonData.getString(String.valueOf(SuccessRate.anHour)),
                            jsonData.getString(String.valueOf(SuccessRate.threeHours)), jsonData.getString(String.valueOf(SuccessRate.twelveHours)),
                            jsonData.getString(String.valueOf(SuccessRate.twentyFourHours)), jsonData.getString(String.valueOf(SuccessRate.aWeek)),
                            jsonData.getString(String.valueOf(SuccessRate.halfAYear)), jsonData.getString(String.valueOf(SuccessRate.aYear)),
                            jsonData.getString(String.valueOf(SuccessRate.history)));
                    authSuccessRateList.add(asr);
                    logger.info("显示： " + asr.getMode()+":"+asr.getA_year());
                    insertToCassandra(asr);
                } else {
                    logger.info("暂无数据！");
                }

            } catch (Exception e) {
                logger.error("error: AuthSuccessRateTask to {}", modes.get(i));
                logger.error(e.getMessage());
//                AlarmMsg alarmMsg = new AlarmMsg();
//                alarmMsg.setAlarmLevel("unstable");
//                alarmMsg.setState("1");
//                alarmMsg.setAlarmMessage("调用："+url+" 返回数据异常");
//                alarmMsg.setClusterName("");
//                alarmMsg.setIp("0.0.0.0");
//                alarmMsg.setPort("");
//                alarmMsg.setAlatime(TimeUtil.getDate());
//                alarmMsg.setSerialnum(0L);
//                cassandraDao.insertAlarmMsg(alarmMsg);
            }
        }
        //插入总平均耗时
        if (status){
            insertTotalSuccessRate(authSuccessRateList);
        }
    }

    /**
     * 模式耗时数据入库
     *
     * @param authSuccessRate
     */
    private void insertToCassandra(Auth_Success_Rate authSuccessRate) {
        authSuccessRateImpl.save(authSuccessRate);
    }

    /**
     * 字符串转成Json格式
     *
     * @param data
     * @return
     */
    private JSONObject StringToJson(String data) {
        JSONObject json;
        if (data != null && !data.equals("")) {
            json = JSONObject.fromObject(data);
        } else {
            json = null;
        }
        return json;
    }

    /**
     * 统计总成功率并记录到数据库
     * @param authSuccessRateList
     */
    private void insertTotalSuccessRate(List<Auth_Success_Rate> authSuccessRateList) {
        int num = authSuccessRateList.size();
        String halfAnHour = "0.00%";
        String anHour = "0.00%";
        String threeHours = "0.00%";
        String twelveHours = "0.00%";
        String twentyFourHour = "0.00%";
        String aWeek = "0.00%";
        String halfAYear = "0.00%";
        String aYear = "0.00%";
        String history = "0.00%";
        for (int i = 0; i < authSuccessRateList.size(); i++) {
            halfAnHour = getSum(halfAnHour,authSuccessRateList.get(i).getHalf_an_hour());
            anHour = getSum(anHour,authSuccessRateList.get(i).getAn_hour());
            threeHours = getSum(threeHours,authSuccessRateList.get(i).getThree_hours());
            twelveHours = getSum(twelveHours,authSuccessRateList.get(i).getTwelve_hours());
            twentyFourHour = getSum(twentyFourHour,authSuccessRateList.get(i).getTwenty_four_hours());
            aWeek = getSum(aWeek,authSuccessRateList.get(i).getA_week());
            halfAYear = getSum(halfAYear,authSuccessRateList.get(i).getHalf_a_year());
            System.out.println("a_year求和前: " + aYear);
            System.out.println("authSuccessRateList.get(i).getA_year(): "+authSuccessRateList.get(i).getA_year());
            aYear = getSum(aYear,authSuccessRateList.get(i).getA_year());
            history = getSum(history,authSuccessRateList.get(i).getHistory());
            System.out.println("a_year求和后: " + aYear);
        }
        System.out.println();
        insertToCassandra(new Auth_Success_Rate("ALL-MODE",authSuccessRateList.get(0).getTimestamp(),
                getAvg(halfAnHour,num),getAvg(anHour,num),getAvg(threeHours,num),getAvg(twelveHours,num),
                getAvg(twentyFourHour,num),getAvg(aWeek,num),getAvg(halfAYear,num),getAvg(aYear,num),getAvg(history,num)));
    }

    /**
     *  成功率求和
     * @param rate1
     * @param rate2
     * @return
     */
    public String getSum(String rate1,String rate2){
        if (rate1.indexOf("%") > 0 && rate2.indexOf("%") > 0){
            return Double.valueOf(rate1.replace("%","")) +
                    Double.valueOf(rate2.replace("%",""))+"%";
        }else if (rate1.indexOf("%") > 0 ){
            return Double.valueOf(rate1.replace("%",""))+"%";
        }else if (rate2.indexOf("%") > 0 ){
            return Double.valueOf(rate2.replace("%",""))+"%";
        }
        return "暂无比对";
    }

    /**
     * 求成功率平均值
     * @param rate
     * @param num
     * @return
     */
    public String getAvg(String rate,int num){
        if (rate.indexOf("%") > 0 && Double.valueOf(rate.replace("%","")) > 0){
            return Double.valueOf(rate.replace("%",""))/num+"%";
        }else{
            return "暂无对比";
        }
    }

    /**
     * 判断本次告警数据是否有效并且同上次测试数据性能下降了40%
     * @param authSuccessRate
     */
    public void insertAlarmMag(Auth_Success_Rate authSuccessRate){
        List<Auth_Success_Rate> authSuccessRateList = authSuccessRateImpl.findLineChartTSuccessLim1(authSuccessRate.getMode());
        Double avgNew = null;
        Double avgOlg = null;

        if (authSuccessRateList != null && authSuccessRateList.size() > 0 && authSuccessRateList.get(0).getHistory().indexOf("%")>0){
            avgOlg = Double.valueOf(authSuccessRateList.get(0).getHistory().replace("%",""));
        }
        if (authSuccessRate != null && authSuccessRate.getHistory().indexOf("%")>0){
            avgNew = Double.valueOf(authSuccessRate.getHistory().replace("%",""));
        }
        if (avgNew != null && avgOlg != null){
            if((avgOlg - avgNew) / avgOlg >  successPoint){
                AlarmMsg alarmMsg = new AlarmMsg();
                alarmMsg.setAlarmLevel("unstable");
                alarmMsg.setState("1");
                alarmMsg.setAlarmMessage(authSuccessRate.getMode()+" 模式在最近的比对率为："+authSuccessRate.getHistory()+" 。对比前一分钟，性能下降过快");
                alarmMsg.setClusterName("");
                alarmMsg.setIp("0.0.0.0");
                alarmMsg.setPort("");
                alarmMsg.setAlatime(authSuccessRate.getTimestamp());
                alarmMsg.setSerialnum(0L);
                logger.info("插入比对率性能下降告警！");
                cassandraDao.insertAlarmMsg(alarmMsg);
            }
        }
    }
}
