package com.yingxin.prms.domain;

import org.springframework.data.cassandra.core.cql.PrimaryKeyType;
import org.springframework.data.cassandra.core.mapping.Column;
import org.springframework.data.cassandra.core.mapping.PrimaryKey;
import org.springframework.data.cassandra.core.mapping.PrimaryKeyColumn;
import org.springframework.data.cassandra.core.mapping.Table;

/**
 * Description:
 * Datetime:    2021/1/12   9:40
 * Author:   gaozhentao
 */
@Table(value = "flowline")
public class FlowLine {

    @PrimaryKey
    String cluster_name_left;  //左集群名称
    @Column("cluster_name_right")
    String clusterNameRight;  //右集群名称
    @Column("coordinate_left")
    String coordinateLeft;  //左坐标
    @Column("coordinate_right")
    String coordinateRight;  //右坐标
    String points;  //坐标
    String color;  //坐标

    public String getPoints() {
        return points;
    }

    public void setPoints(String points) {
        this.points = points;
    }

    public String getColor() {
        return color;
    }

    public void setColor(String color) {
        this.color = color;
    }

    public String getCluster_name_left() {
        return cluster_name_left;
    }

    public void setCluster_name_left(String cluster_name_left) {
        this.cluster_name_left = cluster_name_left;
    }

    public String getClusterNameRight() {
        return clusterNameRight;
    }

    public void setClusterNameRight(String clusterNameRight) {
        this.clusterNameRight = clusterNameRight;
    }

    public String getCoordinateLeft() {
        return coordinateLeft;
    }

    public void setCoordinateLeft(String coordinateLeft) {
        this.coordinateLeft = coordinateLeft;
    }

    public String getCoordinateRight() {
        return coordinateRight;
    }

    public void setCoordinateRight(String coordinateRight) {
        this.coordinateRight = coordinateRight;
    }
    public FlowLine(){

    }

//    (cluster_name_left, cluster_name_right, color, coordinate_left, coordinate_right, points)
    public FlowLine(String cluster_name_left, String clusterNameRight, String color, String coordinateLeft, String coordinateRight, String points) {
        this.cluster_name_left = cluster_name_left;
        this.clusterNameRight = clusterNameRight;
        this.coordinateLeft = coordinateLeft;
        this.coordinateRight = coordinateRight;
        this.points = points;
        this.color = color;
    }
}
