package com.yingxin.prms.config;

import net.sf.json.JSONObject;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 服务区域关系
 * Created by shao on 2021/7/20.
 */
@Configuration
public class ServiceRelationConfig {
    Map<String,Boolean> totalMap = new HashMap<>();
    Map<String,Boolean> jieruqu = new HashMap<>();
    Map<String,Boolean> quanxianguanli = new HashMap<>();
    Map<String,Boolean> jieruguanli = new HashMap<>();
    Map<String,Boolean> hexinyewu = new HashMap<>();
    Map<String,Boolean> suanfaqu = new HashMap<>();
    Map<String,Boolean> rizhihuiju = new HashMap<>();
    Map<String,Boolean> allArea = new HashMap<>();

    @Bean
    public Map<String,Boolean> getAllArea() {
        allArea.put("接入区",true);
        allArea.put("核心业务区",true);
        allArea.put("算法区",true);
        allArea.put("日志汇聚",true);
        allArea.put("权限管理",true);
        allArea.put("接入管理",true);
//        allArea.put(".",true);
//        allArea.put("..",true);
        return allArea;
    }
//
//    /**
//     * 获取总分区的内容
//     * @return
//     */
//    @Bean
//    public Map<String,Boolean> getTotalMap() {
//        totalMap.put("接入区",true);
//        totalMap.put("核心业务区",true);
//        totalMap.put("算法区",true);
//        totalMap.put("日志汇聚服务",true);
//        return totalMap;
//    }
//
//    /**
//     * 获取接入分区的内容
//     * @return
//     */
//    @Bean
//    public Map<String,Boolean> getJieruqu() {
//        jieruqu.put("权限管理",true);
//        jieruqu.put("接入管理",true);
//        jieruqu.put("核心调度服务",false);
//        return jieruqu;
//    }
//
//    /**
//     * 获取权限管理分区的内容
//     * @return
//     */
//    @Bean
//    public Map<String,Boolean> quanxianguanli() {
//        quanxianguanli.put("权限核验（FACL）",false);
//        quanxianguanli.put("redis组件",false);
//        quanxianguanli.put("MySql组件",false);
//        quanxianguanli.put("业务权限配置",false);
//        quanxianguanli.put("业务统计服务",false);
//        quanxianguanli.put("账户管理服务",false);
//        quanxianguanli.put("平台运营管理",false);
//        return quanxianguanli;
//    }
//
//    /**
//     * 获取接入管理分区的内容
//     * @return
//     */
//    @Bean
//    public Map<String,Boolean> getJieruguanli() {
//        jieruguanli.put("公安网用户",false);
//        jieruguanli.put("公安网VPN用户",false);
//        jieruguanli.put("Token核验服务",false);
//        jieruguanli.put("Token方式接入服务",false);
//        jieruguanli.put("签名服务器",false);
//        jieruguanli.put("签名验签接入服务",false);
//        jieruguanli.put("VPN方式接入服务",false);
//        return jieruguanli;
//    }
//
//    /**
//     * 获取核心业务分区的内容
//     * @return
//     */
//    @Bean
//    public Map<String,Boolean> getHexinyewu() {
//        hexinyewu.put("实时身份识别",false);
//        hexinyewu.put("聚档人员实名化",false);
//        hexinyewu.put("其他业务",false);
//        return hexinyewu;
//    }
//
//    /**
//     * 获取算法分区的内容
//     * @return
//     */
//    @Bean
//    public Map<String,Boolean> getSuanfaqu() {
//        suanfaqu.put("算法融合调度",false);
//        suanfaqu.put("人脸识别引擎（1）",false);
//        suanfaqu.put("人脸识别引擎（2）",false);
//        suanfaqu.put("人脸识别引擎（3）",false);
//        suanfaqu.put("图像质量评估引擎",false);
//        suanfaqu.put("其他引擎",false);
//        return suanfaqu;
//    }
//
//    /**
//     * 获取日志汇聚服务分区的内容
//     * @return
//     */
//    @Bean
//    public Map<String,Boolean> getRizhihuiju() {
//        rizhihuiju.put("日志汇聚服务",false);
//        return rizhihuiju;
//    }

    /**
     * 判断服务或分区的上一级分区名称，没有找到配置为顶级分区
     * @param serviceNmae
     * @return
     */

    public String getAreaName(String serviceNmae) {
        String areaName = "";
        switch (serviceNmae){
            case "接入区" :
                areaName = "";
                break;
            case "权限管理" :
                areaName = "接入区";
                break;
            case "接入管理" :
                areaName = "接入区";
                break;
            case "权限核验（FACL）" :
                areaName = "权限管理";
                break;
            case "权限核验facl" :
                areaName = "权限管理";
                break;
            case "redis组件" :
                areaName = "权限管理";
                break;
            case "MySql组件" :
                areaName = "权限管理";
                break;
            case "mysql组件" :
                areaName = "权限管理";
                break;
            case "业务权限配置" :
                areaName = "权限管理";
                break;
            case "账户管理服务" :
                areaName = "权限管理";
                break;
            case "业务统计服务" :
                areaName = "权限管理";
                break;
            case "平台运营管理" :
                areaName = "权限管理";
                break;
            case "公安网用户" :
                areaName = "";
                break;
            case "公安网VPN用户" :
                areaName = "";
                break;
            case "签名服务器" :
                areaName = "接入管理";
                break;
            case "签名验签接入服务" :
                areaName = "接入管理";
                break;
            case "Token方式接入服务" :
                areaName = "接入管理";
                break;
            case "token方式接入服务" :
                areaName = "接入管理";
                break;
            case "Token核验服务" :
                areaName = "接入管理";
                break;
            case "token核验服务" :
                areaName = "接入管理";
                break;
            case "VPN方式接入服务" :
                areaName = "接入管理";
                break;
//            case "核心调度服务" :
//                areaName = "接入区";
//                break;
            case "核心调度服务" :
                areaName = "";
                break;
            case "核心业务区" :
                areaName = "";
                break;
            case "实时身份识别" :
                areaName = "核心业务区";
                break;
            case "聚档人员实名化" :
                areaName = "核心业务区";
                break;
            case "其他业务" :
                areaName = "核心业务区";
                break;
            case "算法区" :
                areaName = "";
                break;
//            case "算法融合调度" :
//                areaName = "算法区";
//                break;
            case "算法融合调度" :
                areaName = "";
                break;
            case "人脸识别引擎（1）" :
                areaName = "算法区";
                break;
            case "人脸识别引擎1" :
                areaName = "算法区";
                break;
            case "人脸识别引擎（2）" :
                areaName = "算法区";
                break;
            case "人脸识别引擎2" :
                areaName = "算法区";
                break;
            case "人脸识别引擎（3）" :
                areaName = "算法区";
                break;
            case "人脸识别引擎3" :
                areaName = "算法区";
                break;
            case "图像质量评估引擎" :
                areaName = "算法区";
                break;
            case "其他引擎" :
                areaName = "算法区";
                break;
            case "日志汇聚" :
                areaName = "";
                break;
            case "日志汇聚服务" :
                areaName = "日志汇聚";
                break;
            case "." :
                areaName = "日志汇聚";
                break;
            case ".." :
                areaName = "日志汇聚";
                break;
            default:
                areaName = "";
        }
        return areaName;
    }
}
