package com.yingxin.prms.api;

import com.yingxin.prms.domain.Auth_Mode_Avg;
import com.yingxin.prms.domain.Auth_Success_Rate;
import com.yingxin.prms.service.dao.AuthModeAvgImpl;
import com.yingxin.prms.service.dao.AuthSuccessRateImpl;
import net.sf.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @Author by shao
 * @Create 2023/3/2 11:57
 */
@RestController
@RequestMapping("/rest/logSystem")
@CrossOrigin(origins = "*")
public class logSystemApi {
    @Autowired
    AuthModeAvgImpl authModeAvg;
    @Autowired
    AuthSuccessRateImpl authSuccessRate;

    @GetMapping("findAllByMode")
    public List<Auth_Mode_Avg> findAllByMode(@RequestParam("mode")String mode) {
        return authModeAvg.findAllByMode(mode);
    }
    @GetMapping("findLineChartTimeData")
    public Map<String,List<Auth_Mode_Avg>> findLineChartTimeData(){
        List<Auth_Mode_Avg> ytcrList = authModeAvg.findLineChartTimeData("YTCR-BASIC");
        List<Auth_Mode_Avg> yrdtytcrList = authModeAvg.findLineChartTimeData("YRDTYTCR-BASIC");
        List<Auth_Mode_Avg> allList = authModeAvg.findLineChartTimeData("ALL-MODE");
        Map<String,List<Auth_Mode_Avg>> result = new HashMap<>();
        result.put("YTCR_BASIC",ytcrList);
        result.put("YRDTYTCR_BASIC",yrdtytcrList);
        result.put("ALL_MODE",allList);
        return result;
    }

    @GetMapping("findLineChartTSuccessData")
    public Map<String,List<Auth_Success_Rate>> findLineChartTSuccessData(){
        List<Auth_Success_Rate> ytcrList = authSuccessRate.findLineChartTSuccessData("YTCR-BASIC");
        List<Auth_Success_Rate> yrdtytcrList = authSuccessRate.findLineChartTSuccessData("YRDTYTCR-BASIC");
        List<Auth_Success_Rate> allList = authSuccessRate.findLineChartTSuccessData("ALL-MODE");
        Map<String,List<Auth_Success_Rate>> result = new HashMap<>();
        result.put("YTCR_BASIC",ytcrList);
        result.put("YRDTYTCR_BASIC",yrdtytcrList);
        result.put("ALL_MODE",allList);
        return result;
    }

}
