package com.yingxin.beijingvehicleflow.service.impl;

import com.yingxin.beijingvehicleflow.dto.ReservationInfoDTO;
import com.yingxin.beijingvehicleflow.entity.IdentityInformation;
import com.yingxin.beijingvehicleflow.entity.Reservation;
import com.yingxin.beijingvehicleflow.mapper.IdentityInformationMapper;
import com.yingxin.beijingvehicleflow.mapper.ReservationMapper;
import com.yingxin.beijingvehicleflow.response.Response;
import com.yingxin.beijingvehicleflow.service.IdentityInformationService;
import com.yingxin.beijingvehicleflow.service.ReservationService;
import com.yingxin.beijingvehicleflow.util.IdCardUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

/**
 * description //TODO
 *
 * @author 226
 * @version 1.0
 * @date 2020/2/23
 */
@Service
public class ReservationServiceImpl implements ReservationService {

    private static Logger LOGGER = LoggerFactory.getLogger(ReservationService.class);


    @Autowired
    private ReservationMapper reservationMapper;

    @Autowired
    private IdentityInformationMapper identityInformationMapper;


    @Override
    @Transactional(rollbackFor = Exception.class)
    public Response insertIdentityInfoAndReservation(ReservationInfoDTO info) throws Exception{
        Reservation reservation = info.getReservation();
        Date date =new Date ();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        reservation.setSubmitTime(sdf.format(date));
        if (identityInformationMapper.updateIdentityInfo(info.getIdentityInformation()) == 1) {
            if (reservationMapper.insertReservation(reservation) == 1) {
                return Response.succ();
            }
        }
        throw new Exception();

    }

    @Override
    public boolean isInsertReservationSucc(Reservation reservation) {
        Date date =new Date ();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        reservation.setSubmitTime(sdf.format(date));
        try {
            return reservationMapper.insertReservation(reservation) == 1;
        } catch (Exception e) {
            LOGGER.error("预约单信息插入异常：", e);
            return false;
        }
    }

    @Override
    public boolean isUpdateAuthInfoSucc(Reservation reservation) {
        try {
            return reservationMapper.updateAuthInfo(reservation) == 1;
        } catch (Exception e) {
            LOGGER.error("更新预约单认证坐标及时间异常：", e);
            return false;
        }
    }

    @Override
    public List<Reservation> selectNotVerifyReservatinsByIdentityId(IdentityInformation info) {
        return reservationMapper.selectNotVerifyReservatinsByIdentityId(info);
    }

    @Override
    public int updateAllVerifyState() {
        return reservationMapper.updateAllVerifyState();
    }
}
