package com.yingxin.beijingvehicleflow.service.impl;

import com.yingxin.beijingvehicleflow.constant.Const;
import com.yingxin.beijingvehicleflow.dto.ReservationsDisplayDTO;
import com.yingxin.beijingvehicleflow.entity.IdentityInformation;
import com.yingxin.beijingvehicleflow.entity.Reservation;
import com.yingxin.beijingvehicleflow.exception.SystemException;
import com.yingxin.beijingvehicleflow.mapper.IdentityInformationMapper;
import com.yingxin.beijingvehicleflow.service.IdentityInformationService;
import com.yingxin.beijingvehicleflow.util.PicUtils;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

/**
 * description //TODO
 *
 * @author 226
 * @version 1.0
 * @date 2020/2/23
 */
@Service
public class IdentityInformationServiceImpl implements IdentityInformationService {

    private static Logger LOGGER = LoggerFactory.getLogger(IdentityInformationService.class);

    @Autowired
    private IdentityInformationMapper identityInformationMapper;

    @Override
    public int insertIdentityInfo(IdentityInformation identityInformation) {
        identityInformationMapper.insertIdentityInfo(identityInformation);
        return identityInformation.getId();
    }

    @Override
    public boolean isUpdateIdentityInfoSucc(IdentityInformation identityInformation) {
        return identityInformationMapper.updateIdentityInfo(identityInformation) == 1;
    }

    @Override
    public JSONObject getwechatInfoByTempCode(String code) {
        BufferedReader in = null;
        String url = "https://api.weixin.qq.com/sns/jscode2session?appid=wxa0c404418dc92510" +
                "&secret=93f2470aa31ae319145b1216704262f6" +
                "&js_code="+code+
                "&grant_type=authorization_code";
        URL realUrl;
        try {
            realUrl = new URL(url);
        } catch (MalformedURLException e) {
            LOGGER.error("通过tempCode获取openId时，URL错误：", e);
            return null;
        }
        URLConnection connection;
        JSONObject jsonObject;
        try {
            connection = realUrl.openConnection();
            in = new BufferedReader(new InputStreamReader(
                    connection.getInputStream()));
            return JSONObject.fromObject(in.readLine());
        } catch (IOException e) {
            LOGGER.error("通过tempCode获取openId时，打开连接错误：", e);
            return null;
        } finally {
            try {
                if (in != null) {
                    in.close();
                }
            } catch (IOException e) {
                LOGGER.error("通过tempCode获取openId时，流关闭异常：", e);
            }
        }

//        return jsonObject.getString("openid");
    }

    @Override
    public IdentityInformation getAllInfoByOpenid(String openid) {
        return identityInformationMapper.getAllInfoByOpenid(openid);
    }

    @Override
    public List<ReservationsDisplayDTO> selectReservatinsByIdentityId(IdentityInformation info) {
        return identityInformationMapper.selectReservatinsByIdentityId(info);
    }


    @Value("${QR-code-validTime}")
    private long validTime;

    @Override
    public boolean isIdentityInfoValid(String authTime) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String checkTime = sdf.format(new Date());
        long milliSeconds;
        try {
            Date authDate = sdf.parse(authTime);
            Date checkDate = sdf.parse(checkTime);
            milliSeconds = checkDate.getTime() - authDate.getTime();

        } catch (ParseException e) {
            LOGGER.error("检验二维码是否过期日期解析异常", e);
            return false;
        }

        return (milliSeconds/60.0/1000.0) < validTime;
    }

    @Override
    public int updateIdentityVerificationById(IdentityInformation info) {
        return identityInformationMapper.updateIdentityVerificationById(info);
    }

    @Override
    public List<Reservation> selectReservationByIdentityId(IdentityInformation info) {
        return identityInformationMapper.selectReservationByIdentityId(info);
    }

    @Override
    public IdentityInformation getAllIdentityInfoById(int id) {
        return identityInformationMapper.getAllIdentityInfoById(id);
    }

    @Autowired
    private RestTemplate restTemplate;

    @Value("${create-QR-code-Fri-Url}")
    private String friQrCodeGenerateUrl;

    @Override
    public String getFriQRCode(String encodedDateStr) throws SystemException{

        HashMap<String,String> hashMap = new HashMap<>(4);
        hashMap.put("bizExtData", encodedDateStr);
        String response;
        try {
            response = restTemplate.postForObject(friQrCodeGenerateUrl,hashMap,String.class);
        } catch (Exception e) {
            LOGGER.error("一所二维码生成接口异常:" , e);
            throw new SystemException("FRI_QR_CODE_GENERATE_FAILED", "一所二维码生成接口调用异常");
        }
        JSONObject responseJson = JSONObject.fromObject(response);

        if (responseJson.getBoolean("success")) {
            return responseJson.getString("qrCode");
        }
        throw new SystemException("FRI_QR_CODE_GENERATE_FAILED", responseJson.getString("errorDec"));
    }

    @Value("${validate-QR-code-Fri-Url}")
    private String friQrCodeDecodeUrl;

    @Override
    public String validateFriQRCode(String qrCodeData) throws SystemException{

        HashMap<String,String> hashMap = new HashMap<>(4);
        hashMap.put("qrCode", qrCodeData);
        String response;
        try {
            response = restTemplate.postForObject(friQrCodeDecodeUrl,hashMap,String.class);
        } catch (Exception e) {
            LOGGER.error("一所二维码校验接口异常:" , e);
            throw new SystemException("FRI_QR_CODE_VALIDATE_FAILED", "一所二维码校验接口调用异常");
        }
        JSONObject responseJson = JSONObject.fromObject(response);

        if (responseJson.getBoolean("success")) {
            return responseJson.getString("bizExtData");
        }
        throw new SystemException("FRI_QR_CODE_GENERATE_FAILED", responseJson.getString("errorDec"));

    }
}
