package com.yingxin.beijingvehicleflow.service.impl;

import com.yingxin.beijingvehicleflow.entity.FloatingPopulation;
import com.yingxin.beijingvehicleflow.entity.Reservation;
import com.yingxin.beijingvehicleflow.mapper.FloatingPopulationMapper;
import com.yingxin.beijingvehicleflow.mapper.ReservationMapper;
import com.yingxin.beijingvehicleflow.response.Response;
import com.yingxin.beijingvehicleflow.service.FloatingPopulationServcie;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

/**
 * description //TODO
 *
 * @author 226
 * @version 1.0
 * @date 2020/2/24
 */
@Service
public class FloatingPopulationServcieImpl implements FloatingPopulationServcie {

    private static Logger LOGGER = LoggerFactory.getLogger(FloatingPopulationServcie.class);

    @Autowired
    private FloatingPopulationMapper populationMapper;

    @Autowired
    private ReservationMapper reservationMapper;


    @Override
    @Transactional(rollbackFor = Exception.class)
    public Response checkFloatingPopulation(FloatingPopulation floatingPopulation) throws Exception {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        floatingPopulation.setCheckTime(sdf.format(new Date()));
        FloatingPopulation selectResult = selectOneByReservationId(floatingPopulation);
        floatingPopulation.setAuthCoordinate(selectResult.getAuthCoordinate());
        floatingPopulation.setAuthTime(selectResult.getAuthTime());
        floatingPopulation.setSubmitCoordinate(selectResult.getSubmitCoordinate());
        floatingPopulation.setSubmitTime(selectResult.getSubmitTime());

        if (populationMapper.insertFloatingPopulation(floatingPopulation) == 1) {
            if (reservationMapper.updateVerifyStateById(floatingPopulation.getReservationId()) == 1) {
                return Response.succ();
            }
        }
        throw new Exception();
    }

    @Override
    public boolean isInsertFloatingPopulationSucc(FloatingPopulation floatingPopulation) {
        try {
            return populationMapper.insertFloatingPopulation(floatingPopulation) == 1;
        } catch (Exception e) {
            LOGGER.error("流动人员数据库录入异常：", e);
            return false;
        }
    }

    @Override
    public FloatingPopulation selectOneByReservationId(FloatingPopulation floatingPopulation) {
        return populationMapper.selectOneByReservationId(floatingPopulation);
    }
}
