package com.yingxin.beijingvehicleflow.service.impl;

import com.yingxin.beijingvehicleflow.constant.Const;
import com.yingxin.beijingvehicleflow.dto.AuthInfo;
import com.yingxin.beijingvehicleflow.entity.IdentityInformation;
import com.yingxin.beijingvehicleflow.response.AuthResponse;
import com.yingxin.beijingvehicleflow.service.AuthService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

/**
 * description //TODO
 *
 * @author 226
 * @version 1.0
 * @date 2020/2/13
 */
@Service
public class AuthServiceImpl implements AuthService {

    private static Logger LOGGER = LoggerFactory.getLogger(AuthService.class);

    @Autowired
    private RestTemplate restTemplate;

    @Value("${auth-url}")
    private String url;

    @Override
    public boolean is0x42AuthSucc(IdentityInformation info) {
        AuthInfo authInfo = new AuthInfo();
        authInfo.setAuthMode("0x42");
        authInfo.setFaceData(info.getFaceImage());
        authInfo.setIdName(info.getName());
        authInfo.setIdNbr(info.getIdCardNumber());
        AuthResponse authResponse;
        try {
            authResponse = restTemplate.postForObject(url, authInfo, AuthResponse.class);
        } catch (Exception e) {
            LOGGER.error("调用认证接口报错:", e);
            return false;
        }
        /* TODO 刪掉 */
        System.out.println("0x42");
        System.out.println(authResponse.getTransNbr());
        System.out.println(authResponse.getErrorDesc());
        System.out.println(authResponse.getAuthResult());
        System.out.println(authResponse.isSuccess());

        return "00XX".equals(authResponse.getAuthResult());
    }

}
