package com.yingxin.beijingvehicleflow.service;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;


/**
 * 月初更新信息修改次数
 *
 * @author 226
 * @version 1.0
 * @date 2020/2/19
 */
@Component
@EnableScheduling
@EnableAsync
public class ScheduleTask {

    private static Logger LOGGER = LoggerFactory.getLogger(ScheduleTask.class);


    @Autowired
    private ReservationService reservationService;

    /**
     *  定时任务
     *
     *  表达式有六位，秒、分、时、日、月、星期
     *  下面表示每个月的一号执行定时任务
     *
     * @date 2020/2/19
     */
    @Async("asyncTaskExecutor")
    @Scheduled(cron = "*/30 * * * * ?")
    public void tasks() {
        try {
            reservationService.updateAllVerifyState();
        } catch (Exception e) {
            LOGGER.error("异步认证次数发放异常：", e);
        }
    }

}