package com.yingxin.beijingvehicleflow.mapper;

import com.yingxin.beijingvehicleflow.dto.ReservationsDisplayDTO;
import com.yingxin.beijingvehicleflow.entity.IdentityInformation;
import com.yingxin.beijingvehicleflow.entity.Reservation;
import org.apache.ibatis.annotations.*;

import java.util.List;

/**
 * 数据库表单对应Mapper
 *
 * @author 226
 * @version 1.0
 * @date 2020/2/23
 */
@Mapper
public interface IdentityInformationMapper {

    /**
     *  第一次插入身份信息表，注册的时候【只插入wechatPhone，wechatOpenid】
     *
     * @date 2020/2/23
     * @param identityInformation 包含wechatPhone，wechatOpenid
     * @return int
     */
    @Insert("insert into identity_information(wechat_phone,wechat_openid) " +
            "values(#{wechatPhone},#{wechatOpenid})")
    @Options(useGeneratedKeys=true, keyProperty="id", keyColumn="id")
    int insertIdentityInfo(IdentityInformation identityInformation);

    /**
     *  预约表单提交的时候更新身份信息数据
     *
     * @date 2020/2/23
     * @param identityInformation 包含除了wechatPhone，wechatOpenid的所有信息
     * @return
     */
    @Update("update identity_information set " +
            "phone_number=#{phoneNumber},toBeijing_date=#{toBeijingDate}" +
            " where id =#{id}")
    int updateIdentityInfo(IdentityInformation identityInformation);

    @Select("select * from identity_information where wechat_openid = #{openid}")
    IdentityInformation getAllInfoByOpenid(String openid);

    @Select("select r.id as reservationId,info.name,info.id_card_number,info.toBeijing_date,r.submit_coordinate,r.identity_id,r.car_number,r.verify_state " +
            "from identity_information AS info LEFT JOIN reservation AS r ON info.id=r.identity_id WHERE info.id = #{id} ")
    List<ReservationsDisplayDTO> selectReservatinsByIdentityId(IdentityInformation info);

    @Update("update identity_information set name=#{name}, id_card_number=#{idCardNumber}," +
            "face_image=#{faceImage},is_authed=#{isAuthed} where id = #{id}")
    int updateIdentityVerificationById(IdentityInformation info);

    //待删除，战士用的
    @Select("select * from reservation where identity_id=#{id}")
    List<Reservation> selectReservationByIdentityId(IdentityInformation info);

    @Select("select * from identity_information where id = #{id}")
    IdentityInformation getAllIdentityInfoById(int id);
}
