package com.yingxin.beijingvehicleflow.mapper;

import com.yingxin.beijingvehicleflow.entity.FloatingPopulation;
import org.apache.ibatis.annotations.Insert;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Select;

/**
 * 数据库表单对应Mapper
 *
 * @author 226
 * @version 1.0
 * @date 2020/2/23
 */
@Mapper
public interface FloatingPopulationMapper {

    @Insert("insert into floating_population(check_coordinate,check_time,submit_coordinate,submit_time," +
            "auth_coordinate,auth_time,worker_id,reservation_id,is_temperature_ok) " +
            "values(#{checkCoordinate},#{checkTime},#{submitCoordinate},#{submitTime}," +
            "#{authCoordinate},#{authTime},#{workerId},#{reservationId},#{isTemperatureOk})")
    int insertFloatingPopulation(FloatingPopulation floatingPopulation);

    @Select("select r.submit_time,r.submit_coordinate,r.auth_time,r.auth_coordinate FROM reservation as r WHERE id = #{reservationId}")
    FloatingPopulation selectOneByReservationId(FloatingPopulation floatingPopulation);
}
