package com.yingxin.beijingvehicleflow.dto;


import com.yingxin.beijingvehicleflow.constant.Const;
import com.yingxin.beijingvehicleflow.util.DesUtil;
import lombok.Data;
import net.sf.json.JSONObject;

import java.util.HashMap;

/**
 * description //TODO
 *
 * @author 226
 * @version 1.0
 * @date 2020/2/24
 */
@Data
public class EncodeData {

    private ReservationInfoDTO data;
    private String qrCodeData;

    public EncodeData(ReservationInfoDTO data) {
        this.data = data;
    }

    public EncodeData encodeData() {
        HashMap<String,Object> map = new HashMap<>(8);
        map.put("authCoordinate", data.getReservation().getAuthCoordinate());
        map.put("authTime",data.getReservation().getAuthTime());
        map.put("id",data.getReservation().getId());

        JSONObject jsonObject = JSONObject.fromObject(map);
        qrCodeData = DesUtil.encrypt(Const.KEY, jsonObject.toString());

        return this;
    }
}
