package com.yingxin.beijingvehicleflow.controller;

import com.yingxin.beijingvehicleflow.constant.Const;
import com.yingxin.beijingvehicleflow.dto.EncodeData;
import com.yingxin.beijingvehicleflow.dto.ReservationInfoDTO;
import com.yingxin.beijingvehicleflow.dto.ReservationsDisplayDTO;
import com.yingxin.beijingvehicleflow.entity.IdentityInformation;
import com.yingxin.beijingvehicleflow.entity.Reservation;
import com.yingxin.beijingvehicleflow.exception.SystemException;
import com.yingxin.beijingvehicleflow.response.Response;
import com.yingxin.beijingvehicleflow.service.AuthService;
import com.yingxin.beijingvehicleflow.service.IdentityInformationService;
import com.yingxin.beijingvehicleflow.service.ReservationService;
import com.yingxin.beijingvehicleflow.util.AESUtil;
import com.yingxin.beijingvehicleflow.util.DesUtil;
import com.yingxin.beijingvehicleflow.util.IdCardUtil;
import com.yingxin.beijingvehicleflow.util.PicUtils;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * description //TODO
 *
 * @author 226
 * @version 1.0
 * @date 2020/2/24
 */
@RestController
@CrossOrigin
@RequestMapping("/bjapi/v1")
public class IdentityInfoController {

    private static Logger LOGGER = LoggerFactory.getLogger(IdentityInfoController.class);


    @Autowired
    private IdentityInformationService identityInformationService;

    /**
     *  根据tempCode去获取openId,然后在数据库中查看是否有与其相同的openId
     *
     * @date 2020/2/21
     * @param json {"code":""}
     * @return com.yingxin.covid19prevention.response.Response
     */
    @PostMapping("/identity/exist/state")
    public Response isIdentityInfoExist(@RequestBody String json) {

        JSONObject jsonObject = JSONObject.fromObject(json);
        JSONObject jsonAfterLogin = identityInformationService.getwechatInfoByTempCode(jsonObject.getString("code"));
        IdentityInformation info = identityInformationService.getAllInfoByOpenid(jsonAfterLogin.getString("openid"));
        if (info == null) {
            return Response.fail();
        }

        return new Response<IdentityInformation>(true,"","",info);
    }

    /**
     *  将获取到的加密手机号进行解密,将解密的手机号和获取到的openId一起存到用户表中,
     *
     * @date 2020/2/21
     * @param json code、iv、encryptedData
     * @return com.yingxin.covid19prevention.response.Response  userId
     */
    @PostMapping("/identity/wechat")
    public Response getDecryptData(@RequestBody String json) {
        JSONObject jsonObject = JSONObject.fromObject(json);
        String tempCode = jsonObject.getString("code");
        String iv = jsonObject.getString("iv");
        String encryptedData = jsonObject.getString("encryptedData");
        JSONObject loginJson = identityInformationService.getwechatInfoByTempCode(tempCode);
        String sessionKey = loginJson.getString("session_key");
        String result;
        try {
            result = AESUtil.decryptForWeChatApplet(encryptedData, sessionKey, iv);
        } catch (Exception e) {
            LOGGER.error("获取微信手机号码解密异常：", e);
            return Response.fail("Decrypt-ERROR", "获取微信手机号码解密异常");
        }

        JSONObject wechatJson;
        String weChatPhone;
        String openid;
        try {
            wechatJson = JSONObject.fromObject(result);
            weChatPhone = wechatJson.getString("phoneNumber");
            openid = loginJson.getString("openid");
        } catch (Exception e) {
            LOGGER.error("解密结果json解析异常", e);
            return Response.fail("JSON-PARSE-ERROR", "解密结果json解析异常");
        }

        IdentityInformation info = new IdentityInformation();
        info.setWechatPhone(weChatPhone);
        info.setWechatOpenid(openid);
        int resultAfterInsert = identityInformationService.insertIdentityInfo(info);
        if (resultAfterInsert > 0) {
            return new Response<Integer>(true,"","",resultAfterInsert);
        }

        return Response.fail();

    }

    @PostMapping("/identity/reservation/display")
    public List<ReservationsDisplayDTO> selectReservatinsByIdentityId(@RequestBody IdentityInformation info) {

        if (identityInformationService.selectReservationByIdentityId(info).size()==0) {
            return new ArrayList<>();
        }
        return identityInformationService.selectReservatinsByIdentityId(info);
    }


    @Autowired
    private AuthService authService;

    @Autowired
    private ReservationService reservationService;
    /**
     *  认证接口，此处不用再次判断身份证号码 【二维码生成-----一所健康码】
     *
     *  1.图片压缩
     *
     * @date 2020/2/24
     * @param reservationInfoDTO
     * @return com.yingxin.beijingvehicleflow.response.Response
     */
    @PostMapping("/identity/auth")
    public Response verifyIdentity(@RequestBody ReservationInfoDTO reservationInfoDTO) {
        IdentityInformation info = reservationInfoDTO.getIdentityInformation();
        /*图片压缩*/
        info.setFaceImage(
                PicUtils.compressImage(info.getFaceImage(),
                        Const.FACE_IMG_SIZE));
//        if (!authService.is0x42AuthSucc(info)) {
//            return Response.fail("AUTH-FAILED","实名认证失败。");
//        }
        Reservation reservation = reservationInfoDTO.getReservation();
        Date date =new Date ();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        reservation.setAuthTime(sdf.format(date));
        reservationInfoDTO.setReservation(reservation);

        if (!reservationService.isUpdateAuthInfoSucc(reservation)) {
            return Response.fail("UPDATE-FAILED","更新预约单认证信息失败");
        }
        EncodeData encodeData = new EncodeData(reservationInfoDTO).encodeData();
        /*生成一所健康二维码*/
        String qrCode;
        try {
            qrCode = identityInformationService.getFriQRCode(encodeData.getQrCodeData());
        } catch (SystemException e) {
            LOGGER.error(e.getCode()+"->"+e.getMsg(), e);
            return Response.fail(e.getCode(), e.getMsg());
        }
        encodeData.setQrCodeData(qrCode);

        return new Response<EncodeData>(true,"","", encodeData);

    }

    /**
     *  曾经的解密接口【二维码解密-----一所健康码】
     *
     * @date 2020/2/25
     * @param json
     * @return com.yingxin.beijingvehicleflow.response.Response
     */
    @PostMapping("/identity/code")
    public Response selectOneByEncodedId(@RequestBody String json) {
        IdentityInformation info;
        JSONObject datafterDecryptJson;

        try {
            JSONObject jsonObject = JSONObject.fromObject(json);
            String encodedData = jsonObject.getString("encodedData");

            /*解密一所健康二维码*/
            String qrDate;
            try {
                qrDate = identityInformationService.validateFriQRCode(encodedData);
            } catch (SystemException e) {
                LOGGER.error(e.getCode()+"->"+e.getMsg(), e);
                return Response.fail(e.getCode(), e.getMsg());
            }
            String datafterDecryptStr = DesUtil.decrypt(Const.KEY, qrDate);
            datafterDecryptJson = JSONObject.fromObject(datafterDecryptStr);
            String authTime = datafterDecryptJson.getString("authTime");

            if (!identityInformationService.isIdentityInfoValid(authTime)) {
                return Response.fail("INVALID-CODE","二维码已过期，请重新生成二维码。");
            }
        } catch (JSONException e) {
            LOGGER.error("解密查询接口Json解析异常", e);
            return Response.fail("JSON-PARSE-ERROR","json解析异常");
        } catch (Exception e) {
            LOGGER.error("解密查询接口异常", e);
            return Response.fail("DECRYPT-ERROR","解密异常！");
        }

        return new Response<JSONObject>(true, "", "",datafterDecryptJson);
    }

    @PostMapping("/identity/verification")
    public Response verifyIdentity(@RequestBody IdentityInformation info) {

        if (!IdCardUtil.isValidatedAllIdcard(info.getIdCardNumber())) {
            return Response.fail("ERROR-ID-NUMBER", "身份证格式有误，请重新输入。");
        }
        /*图片压缩*/
        info.setFaceImage(
                PicUtils.compressImage(info.getFaceImage(),
                        Const.FACE_IMG_SIZE));
//        try {
//            if (!authService.is0x42AuthSucc(info)) {
//                return Response.fail("AUTH-FAILED","实名认证失败。");
//            }
//        } catch (Exception e) {
//            LOGGER.error("身份认证异常:", e);
//            return Response.fail("AUTH-FAILED","实名认证失败。");
//        }

        try {
            info.setIsAuthed(1);
//            return identityInformationService.updateIdentityVerificationById(info)>0?Response.succ():Response.fail();
            identityInformationService.updateIdentityVerificationById(info);
            return Response.succ();
        } catch (Exception e) {
            LOGGER.error("身份认证数据update异常:", e);
            return Response.fail("UNKNOWN-ERROR", "系统繁忙，请稍后重试。");
        }

    }

    @PostMapping("/phone")
    public IdentityInformation getPhoneById(@RequestBody IdentityInformation info) {
        return identityInformationService.getAllIdentityInfoById(info.getId());
    }


}
